/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.commands;

import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.core.commands.SpeciesNotFoundException;
import forestry.core.commands.TemplateNotFoundException;
import forestry.core.utils.BlockUtil;
import forestry.core.worldgen.WorldGenBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public final class TreeGenHelper {
    public static WorldGenerator getWorldGen(String treeName, EntityPlayer player, BlockPos pos) throws SpeciesNotFoundException, TemplateNotFoundException {
        ITreeGenome treeGenome = TreeGenHelper.getTreeGenome(treeName);
        if (treeGenome == null) {
            return null;
        }
        ITree tree = TreeManager.treeRoot.getTree(player.field_70170_p, treeGenome);
        return tree.getTreeGenerator(player.field_70170_p, pos, true);
    }

    public static void generateTree(WorldGenerator gen, EntityPlayer player, BlockPos pos) {
        World world;
        IBlockState blockState = world.func_180495_p(pos = (world = player.field_70170_p).func_175623_d(pos.func_177977_b()) ? BlockUtil.getNextSolidDownPos(world, pos) : BlockUtil.getNextReplaceableUpPos(world, pos));
        if (BlockUtil.canPlaceTree(blockState, world, pos)) {
            if (gen instanceof WorldGenBase) {
                ((WorldGenBase)gen).generate(world, pos, false);
            } else {
                gen.func_180709_b(world, world.field_73012_v, pos);
            }
        }
    }

    private static ITreeGenome getTreeGenome(String speciesName) throws SpeciesNotFoundException, TemplateNotFoundException {
        IAllele species = null;
        for (String uid : AlleleManager.alleleRegistry.getRegisteredAlleles().keySet()) {
            IAllele allele;
            if (!uid.equals(speciesName) || !((allele = AlleleManager.alleleRegistry.getAllele(uid)) instanceof IAlleleTreeSpecies)) continue;
            species = (IAlleleTreeSpecies)allele;
            break;
        }
        if (species == null) {
            for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                if (!(allele instanceof IAlleleTreeSpecies) || !allele.getName().replaceAll("\\s", "").equals(speciesName)) continue;
                species = (IAlleleTreeSpecies)allele;
                break;
            }
        }
        if (species == null) {
            throw new SpeciesNotFoundException(speciesName);
        }
        IAllele[] template = TreeManager.treeRoot.getTemplate(species.getUID());
        if (template == null) {
            throw new TemplateNotFoundException((IAlleleSpecies)species);
        }
        return TreeManager.treeRoot.templateAsGenome(template);
    }
}

