/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodHelper;
import forestry.arboriculture.blocks.WoodTypeStateMapper;
import forestry.arboriculture.blocks.property.PropertyWoodType;
import forestry.core.proxy.Proxies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockArbLog
extends BlockLog
implements IWoodTyped,
IStateMapperRegister,
IItemModelRegister {
    private static final int VARIANTS_PER_BLOCK = 4;
    private static final int VARIANTS_META_MASK = 3;
    private final boolean fireproof;
    private final int blockNumber;

    public static List<BlockArbLog> create(boolean fireproof) {
        ArrayList<BlockArbLog> logs = new ArrayList<BlockArbLog>();
        int blockCount = PropertyWoodType.getBlockCount(4);
        for (int blockNumber = 0; blockNumber < blockCount; ++blockNumber) {
            final PropertyWoodType variant = PropertyWoodType.create("variant", blockNumber, 4);
            BlockArbLog log = new BlockArbLog(fireproof, blockNumber){

                @Override
                @Nonnull
                protected PropertyWoodType getVariant() {
                    return variant;
                }
            };
            logs.add(log);
        }
        return logs;
    }

    private BlockArbLog(boolean fireproof, int blockNumber) {
        this.fireproof = fireproof;
        this.blockNumber = blockNumber;
        PropertyWoodType variant = this.getVariant();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)variant, (Comparable)((Object)variant.getFirstType())).func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.NONE));
        this.setHarvestLevel("axe", 0);
        this.func_149647_a(Tabs.tabArboriculture);
    }

    @Override
    @Nonnull
    public String getBlockKind() {
        return "log";
    }

    @Override
    public boolean isFireproof() {
        return this.fireproof;
    }

    @Nonnull
    protected abstract PropertyWoodType getVariant();

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public IBlockState func_176203_a(int meta) {
        EnumWoodType woodType = this.getWoodType(meta);
        BlockLog.EnumAxis axis = BlockArbLog.getAxis(meta);
        return this.func_176223_P().func_177226_a((IProperty)this.getVariant(), (Comparable)((Object)woodType)).func_177226_a((IProperty)field_176299_a, (Comparable)axis);
    }

    @Override
    @Nonnull
    public EnumWoodType getWoodType(int meta) {
        int variantMeta = (meta & 3) + this.blockNumber * 4;
        return EnumWoodType.byMetadata(variantMeta);
    }

    @Override
    @Nonnull
    public Collection<EnumWoodType> getWoodTypes() {
        return this.getVariant().func_177700_c();
    }

    private static BlockLog.EnumAxis getAxis(int meta) {
        switch (meta & 0xC) {
            case 0: {
                return BlockLog.EnumAxis.Y;
            }
            case 4: {
                return BlockLog.EnumAxis.X;
            }
            case 8: {
                return BlockLog.EnumAxis.Z;
            }
        }
        return BlockLog.EnumAxis.NONE;
    }

    public int func_176201_c(IBlockState state) {
        int i = this.func_180651_a(state);
        switch ((BlockLog.EnumAxis)state.func_177229_b((IProperty)field_176299_a)) {
            case X: {
                i |= 4;
                break;
            }
            case Z: {
                i |= 8;
                break;
            }
            case NONE: {
                i |= 0xC;
            }
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getVariant(), field_176299_a});
    }

    protected ItemStack func_180643_i(IBlockState state) {
        int meta = this.func_180651_a(state);
        Item item = Item.func_150898_a((Block)this);
        return new ItemStack(item, 1, meta);
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumWoodType)((Object)state.func_177229_b((IProperty)this.getVariant()))).getMetadata() - this.blockNumber * 4;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        BlockLog.EnumAxis axis = BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k());
        EnumWoodType woodType = this.getWoodType(meta);
        return this.func_176223_P().func_177226_a((IProperty)this.getVariant(), (Comparable)((Object)woodType)).func_177226_a((IProperty)field_176299_a, (Comparable)axis);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (EnumWoodType woodType : this.getVariant().func_177700_c()) {
            list.add(TreeManager.woodAccess.getLog(woodType, this.fireproof));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerVariant(item, WoodHelper.getResourceLocations(this));
        manager.registerItemModel(item, new WoodHelper.WoodMeshDefinition(this));
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        int meta = this.func_176201_c(blockState);
        EnumWoodType woodType = this.getWoodType(meta);
        return woodType.getHardness();
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.fireproof) {
            return 0;
        }
        if (face == EnumFacing.DOWN) {
            return 20;
        }
        if (face != EnumFacing.UP) {
            return 10;
        }
        return 5;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.fireproof) {
            return 0;
        }
        return super.getFlammability(world, pos, face);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        Proxies.render.registerStateMapper((Block)this, (IStateMapper)new WoodTypeStateMapper(this, this.getVariant()));
    }
}

