/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IFruitFamily;
import forestry.core.render.TextureManager;
import forestry.core.utils.Translator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FruitProviderNone
implements IFruitProvider {
    private static final HashMap<String, OverlayType> overlayTypes = new HashMap();
    private final String unlocalizedDescription;
    private final IFruitFamily family;
    protected int ripeningPeriod = 10;
    private OverlayType overlay = null;

    public FruitProviderNone(String unlocalizedDescription, IFruitFamily family) {
        this.unlocalizedDescription = unlocalizedDescription;
        this.family = family;
    }

    public IFruitProvider setOverlay(String ident) {
        this.overlay = overlayTypes.get(ident);
        return this;
    }

    @Override
    public IFruitFamily getFamily() {
        return this.family;
    }

    @Override
    @Nonnull
    public List<ItemStack> getFruits(ITreeGenome genome, World world, BlockPos pos, int ripeningTime) {
        return Collections.emptyList();
    }

    @Override
    public boolean requiresFruitBlocks() {
        return false;
    }

    @Override
    public boolean trySpawnFruitBlock(ITreeGenome genome, World world, BlockPos pos) {
        return false;
    }

    @Override
    public int getColour(ITreeGenome genome, IBlockAccess world, BlockPos pos, int ripeningTime) {
        return 0xFFFFFF;
    }

    @Override
    public int getDecorativeColor() {
        return 0xFFFFFF;
    }

    @Override
    public boolean markAsFruitLeaf(ITreeGenome genome, World world, BlockPos pos) {
        return false;
    }

    @Override
    public int getRipeningPeriod() {
        return this.ripeningPeriod;
    }

    @Override
    @Nonnull
    public Map<ItemStack, Float> getProducts() {
        return Collections.emptyMap();
    }

    @Override
    @Nonnull
    public Map<ItemStack, Float> getSpecialty() {
        return Collections.emptyMap();
    }

    @Override
    public String getDescription() {
        return Translator.translateToLocal(this.unlocalizedDescription);
    }

    @Override
    public short getSpriteIndex(ITreeGenome genome, IBlockAccess world, BlockPos pos, int ripeningTime, boolean fancy) {
        if (this.overlay != null) {
            return this.overlay.texUID;
        }
        return -1;
    }

    @Override
    public short getDecorativeSpriteIndex() {
        if (this.overlay != null) {
            return this.overlay.texUID;
        }
        return -1;
    }

    @Override
    public void registerSprites() {
        if (this.overlay != null) {
            TextureManager.registerSpriteUID(this.overlay.texUID, "blocks/leaves/fruits." + this.overlay.ident);
        }
    }

    @Override
    @Nullable
    public String getModelName() {
        return null;
    }

    @Override
    @Nonnull
    public String getModID() {
        return "Forestry";
    }

    static {
        overlayTypes.put("berries", new OverlayType("berries", 1000));
        overlayTypes.put("pomes", new OverlayType("pomes", 1001));
        overlayTypes.put("nuts", new OverlayType("nuts", 1002));
        overlayTypes.put("citrus", new OverlayType("citrus", 1003));
        overlayTypes.put("plums", new OverlayType("plums", 1004));
    }

    private static class OverlayType {
        public final String ident;
        public final short texUID;

        public OverlayType(String ident, short texUID) {
            this.ident = ident;
            this.texUID = texUID;
        }
    }
}

