/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.food.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

import forestry.api.food.BeverageManager;
import forestry.core.inventory.ItemInventory;
import forestry.food.PluginFood;

public class ItemInventoryInfuser extends ItemInventory {
	private static final short inputSlot = 0;
	private static final short outputSlot = 1;
	private static final short ingredientSlot1 = 2;
	private static final short ingredientSlotCount = 4;

	public ItemInventoryInfuser(EntityPlayer player, ItemStack itemStack) {
		super(player, 6, itemStack);
	}

	@Override
	public void onSlotClick(int slotIndex, EntityPlayer player) {

		// Need input
		ItemStack input = func_70301_a(inputSlot);
		if (input == null) {
			return;
		}

		// Output slot may not be occupied
		if (func_70301_a(outputSlot) != null) {
			return;
		}

		// Need a valid base
		if (PluginFood.items.beverage != input.func_77973_b()) {
			return;
		}

		// Create the seasoned item
		ItemStack[] ingredients = new ItemStack[4];
		for (int i = 0; i < 4; i++) {
			ingredients[i] = func_70301_a(i + ingredientSlot1);
		}

		// Only continue if there is anything to season
		if (!BeverageManager.infuserManager.hasMixtures(ingredients)) {
			return;
		}

		ItemStack seasoned = BeverageManager.infuserManager.getSeasoned(input, ingredients);
		if (seasoned == null) {
			return;
		}

		// Remove required ingredients.
		ItemStack[] toRemove = BeverageManager.infuserManager.getRequired(ingredients);
		for (ItemStack templ : toRemove) {
			ItemStack ghost = templ.func_77946_l();

			for (int i = ingredientSlot1; i < this.func_70302_i_(); i++) {
				ItemStack ingredient = func_70301_a(i);
				if (ingredient == null) {
					continue;
				}
				if (ghost.field_77994_a <= 0) {
					break;
				}

				if (ghost.func_77952_i() >= 0 && ingredient.func_77969_a(ghost)
						|| ghost.func_77952_i() < 0 && ghost.func_77973_b() == ingredient.func_77973_b()) {
					ItemStack removed = func_70298_a(i, 1);
					ghost.field_77994_a -= removed.field_77994_a;
				}
			}
		}
		func_70298_a(inputSlot, 1);
		func_70299_a(outputSlot, seasoned);
	}

	@Override
	public String func_70005_c_() {
		return "Infuser";
	}

	@Override
	public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
		if (slotIndex == inputSlot) {
			return PluginFood.items.beverage == itemStack.func_77973_b();
		} else if (slotIndex >= ingredientSlot1 && slotIndex < ingredientSlot1 + ingredientSlotCount) {
			return BeverageManager.infuserManager.isIngredient(itemStack);
		}
		return false;
	}
}
