/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.blocks;

import com.google.common.collect.ImmutableMap;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.Tabs;
import forestry.apiculture.tiles.TileCandle;
import forestry.core.blocks.IColoredBlock;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemStackUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class BlockCandle
extends BlockTorch
implements IItemModelRegister,
ITileEntityProvider,
IColoredBlock {
    private static final ImmutableMap<String, Integer> colours;
    public static final Set<Item> lightingItems;
    public static final String colourTagName = "colour";
    private static final PropertyEnum<State> STATE;
    private final ThreadLocal<ItemStack> drop = new ThreadLocal();

    public BlockCandle() {
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(Tabs.tabApiculture);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176596_a, (Comparable)EnumFacing.UP).func_177226_a(STATE, (Comparable)((Object)State.OFF)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176596_a, STATE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((TileCandle)world.func_175625_s(pos)).isLit()) {
            state = state.func_177226_a(STATE, (Comparable)((Object)State.ON));
        }
        return super.func_176221_a(state, world, pos);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileCandle();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerItemModel(item, 0, "candle");
        manager.registerItemModel(item, 1, "candle");
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileCandle && ((TileCandle)tileEntity).isLit()) {
            return 14;
        }
        return 0;
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
        itemList.add(new ItemStack((Block)this, 1, 0));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof TileCandle)) {
            return false;
        }
        TileCandle tileCandle = (TileCandle)tileEntity;
        boolean isLit = tileCandle.isLit();
        boolean flag = false;
        boolean toggleLitState = true;
        if (!isLit) {
            if (heldItem == null || !lightingItems.contains(heldItem.func_77973_b())) {
                toggleLitState = false;
            } else if (ItemStackUtil.equals((Block)this, heldItem) && BlockCandle.isLit(heldItem)) {
                toggleLitState = true;
            }
        }
        if (heldItem != null) {
            if (ItemStackUtil.equals((Block)this, heldItem)) {
                if (!BlockCandle.isLit(heldItem)) {
                    if (heldItem.func_77942_o() && heldItem.func_77978_p().func_74764_b(colourTagName)) {
                        tileCandle.setColour(heldItem.func_77978_p().func_74762_e(colourTagName));
                    } else {
                        tileCandle.setColour(0xFFFFFF);
                    }
                } else {
                    toggleLitState = true;
                }
                flag = true;
            } else {
                boolean dyed = BlockCandle.tryDye(heldItem, isLit, tileCandle);
                if (dyed) {
                    worldIn.func_175704_b(pos, pos);
                    toggleLitState = false;
                    flag = true;
                }
            }
        }
        if (toggleLitState) {
            tileCandle.setLit(!isLit);
            worldIn.func_175704_b(pos, pos);
            worldIn.field_72984_F.func_76320_a("checkLight");
            worldIn.func_175664_x(pos);
            worldIn.field_72984_F.func_76319_b();
            flag = true;
        }
        return flag;
    }

    private static boolean tryDye(ItemStack held, boolean isLit, TileCandle tileCandle) {
        for (Map.Entry colour : colours.entrySet()) {
            String colourName = (String)colour.getKey();
            for (ItemStack stack : OreDictionary.getOres((String)colourName)) {
                if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)held, (boolean)true)) continue;
                if (isLit) {
                    tileCandle.setColour((Integer)colour.getValue());
                } else {
                    tileCandle.addColour((Integer)colour.getValue());
                }
                return true;
            }
        }
        return false;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            ItemStack itemStack = this.getCandleDrop((IBlockAccess)world, pos);
            this.drop.set(itemStack);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack dropStack = this.drop.get();
        this.drop.remove();
        if (dropStack == null) {
            dropStack = this.getCandleDrop(world, pos);
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(1);
        drops.add(dropStack);
        return drops;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getCandleDrop((IBlockAccess)world, pos);
    }

    private ItemStack getCandleDrop(IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof TileCandle)) {
            return null;
        }
        TileCandle tileCandle = (TileCandle)tileEntity;
        int colour = tileCandle.getColour();
        int newMeta = tileCandle.isLit() ? 1 : 0;
        ItemStack itemStack = new ItemStack((Block)this, 1, newMeta);
        if (colour != 0xFFFFFF) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a(colourTagName, colour);
            itemStack.func_77982_d(tag);
        }
        return itemStack;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileCandle tileCandle = (TileCandle)world.func_175625_s(pos);
        int colour = BlockCandle.getColourValueFromItemStack(stack);
        boolean isLit = BlockCandle.isLit(stack);
        tileCandle.setColour(colour);
        tileCandle.setLit(isLit);
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileCandle tileCandle = TileUtil.getTile((IBlockAccess)worldIn, pos, TileCandle.class);
        if (tileCandle != null && tileCandle.isLit()) {
            super.func_180655_c(stateIn, worldIn, pos, rand);
        }
    }

    private static int getColourValueFromItemStack(ItemStack itemStack) {
        NBTTagCompound tag;
        int value = 0xFFFFFF;
        if (itemStack.func_77942_o() && (tag = itemStack.func_77978_p()).func_74764_b(colourTagName)) {
            value = tag.func_74762_e(colourTagName);
        }
        return value;
    }

    public static boolean isLit(ItemStack itemStack) {
        return itemStack.func_77952_i() > 0;
    }

    public static void addItemToLightingList(Item item) {
        if (item == null) {
            throw new NullPointerException();
        }
        if (!lightingItems.contains(item)) {
            lightingItems.add(item);
        }
    }

    public ItemStack getUnlitCandle(int amount) {
        ItemStack itemStack = new ItemStack((Block)this, amount, 0);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(colourTagName, 0xFFFFFF);
        itemStack.func_77982_d(tag);
        return itemStack;
    }

    public ItemStack getLitCandle(int amount) {
        ItemStack itemStack = new ItemStack((Block)this, amount, 1);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(colourTagName, 0xFFFFFF);
        itemStack.func_77982_d(tag);
        return itemStack;
    }

    @Override
    public int colorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        TileCandle tileCandle = TileUtil.getTile(worldIn, pos, TileCandle.class);
        if (tileCandle != null) {
            return tileCandle.getColour();
        }
        return 0xFFFFFF;
    }

    static {
        STATE = PropertyEnum.func_177709_a((String)"state", State.class);
        colours = ImmutableMap.builder().put((Object)"dyeWhite", (Object)new Color(255, 255, 255).getRGB()).put((Object)"dyeOrange", (Object)new Color(219, 125, 62).getRGB()).put((Object)"dyeMagenta", (Object)new Color(255, 20, 255).getRGB()).put((Object)"dyeLightBlue", (Object)new Color(107, 138, 201).getRGB()).put((Object)"dyeYellow", (Object)new Color(255, 255, 20).getRGB()).put((Object)"dyeLime", (Object)new Color(20, 255, 20).getRGB()).put((Object)"dyePink", (Object)new Color(208, 132, 153).getRGB()).put((Object)"dyeGray", (Object)new Color(74, 74, 74).getRGB()).put((Object)"dyeLightGray", (Object)new Color(154, 161, 161).getRGB()).put((Object)"dyeCyan", (Object)new Color(20, 255, 255).getRGB()).put((Object)"dyePurple", (Object)new Color(126, 61, 181).getRGB()).put((Object)"dyeBlue", (Object)new Color(20, 20, 255).getRGB()).put((Object)"dyeBrown", (Object)new Color(79, 50, 31).getRGB()).put((Object)"dyeGreen", (Object)new Color(53, 70, 27).getRGB()).put((Object)"dyeRed", (Object)new Color(150, 52, 48).getRGB()).put((Object)"dyeBlack", (Object)new Color(20, 20, 20).getRGB()).build();
        lightingItems = new HashSet<Item>(Arrays.asList(Items.field_151033_d, Items.field_151145_ak, Item.func_150898_a((Block)Blocks.field_150478_aa)));
    }

    private static enum State implements IStringSerializable
    {
        ON("on"),
        OFF("off");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

