/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins.compat;

import com.google.common.collect.ImmutableMap;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.Farmables;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.IBackpackDefinition;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.items.EnumPropolis;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.PluginCore;
import forestry.core.blocks.BlockBogEarth;
import forestry.core.circuits.Circuit;
import forestry.core.circuits.CircuitLayout;
import forestry.core.fluids.Fluids;
import forestry.core.items.EnumElectronTube;
import forestry.core.items.ItemRegistryCore;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.ModUtil;
import forestry.energy.PluginEnergy;
import forestry.energy.blocks.BlockRegistryEnergy;
import forestry.energy.circuits.CircuitElectricBoost;
import forestry.energy.circuits.CircuitElectricChoke;
import forestry.energy.circuits.CircuitElectricEfficiency;
import forestry.farming.circuits.CircuitFarmLogic;
import forestry.farming.logic.FarmLogicRubber;
import forestry.farming.logic.FarmableBasicIC2Crop;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.compat.BlockRegistryIC2;
import ic2.api.item.IC2Items;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.Recipes;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.event.FMLInterModComms;

@ForestryPlugin(pluginID="IC2", name="IndustrialCraft2", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.ic2.description")
public class PluginIC2
extends BlankForestryPlugin {
    public static final String modId = "IC2";
    public static PluginIC2 instance;
    private static ItemStack rubberSapling;
    private static ItemStack rubber;
    public static ItemStack rubberWood;
    public static ItemStack resin;
    public BlockRegistryIC2 blocks;

    public PluginIC2() {
        if (instance == null) {
            instance = this;
        }
    }

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded(modId);
    }

    @Override
    public String getFailMessage() {
        return "IndustrialCraft2 not found";
    }

    @Override
    @Nonnull
    public Set<String> getDependencyUids() {
        Set<String> dependencyUids = super.getDependencyUids();
        dependencyUids.add("forestry.farming");
        dependencyUids.add("forestry.factory");
        return dependencyUids;
    }

    @Override
    @Optional.Method(modid="IC2")
    public void preInit() {
        super.preInit();
        rubberWood = IC2Items.getItem((String)"rubber_wood");
        resin = IC2Items.getItem((String)"misc_resource", (String)"resin");
        rubberSapling = IC2Items.getItem((String)"sapling");
        rubber = IC2Items.getItem((String)"crafting", (String)"rubber");
        Circuit.farmRubberManual = new CircuitFarmLogic("manualRubber", new FarmLogicRubber());
        CircuitLayout layoutEngineTin = new CircuitLayout("engine.tin", CircuitSocketType.ELECTRIC_ENGINE);
        ChipsetManager.circuitRegistry.registerLayout(layoutEngineTin);
    }

    @Override
    @Optional.Method(modid="IC2")
    public void doInit() {
        super.doInit();
        if (Recipes.recyclerBlacklist != null) {
            ItemRegistryApiculture beeItems = PluginApiculture.items;
            if (beeItems != null) {
                Recipes.recyclerBlacklist.add((IRecipeInput)new RecipeInputItemStack(new ItemStack((Item)beeItems.beeQueenGE)));
                Recipes.recyclerBlacklist.add((IRecipeInput)new RecipeInputItemStack(new ItemStack((Item)beeItems.beePrincessGE)));
            }
        } else {
            Log.error("IC2 Recipes.recyclerBlacklist not found.", new Object[0]);
        }
        Circuit.energyElectricChoke1 = new CircuitElectricChoke("electric.choke.1");
        Circuit.energyElectricEfficiency1 = new CircuitElectricEfficiency("electric.efficiency.1");
        Circuit.energyElectricBoost1 = new CircuitElectricBoost("electric.boost.1", 2, 7, 20);
        Circuit.energyElectricBoost2 = new CircuitElectricBoost("electric.boost.2", 2, 15, 40);
        this.blocks.electricalEngine.init();
        this.blocks.generator.init();
    }

    @Override
    public void postInit() {
        ItemStack rubberLeaves;
        super.postInit();
        if (BackpackManager.backpackInterface == null) {
            return;
        }
        IBackpackDefinition forester = BackpackManager.backpackInterface.getBackpack("forestry.forester");
        if (resin != null) {
            forester.addValidItem(resin);
        }
        if (rubber != null) {
            forester.addValidItem(rubber);
        }
        if (rubberSapling != null) {
            forester.addValidItem(rubberSapling);
        }
        if ((rubberLeaves = IC2Items.getItem((String)"leaves")) != null) {
            forester.addValidItem(rubberLeaves);
        }
    }

    @Override
    public void registerCrates() {
        ItemStack brass;
        ItemStack silver;
        ItemStack uuMatter;
        ItemStack scrap;
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        if (crateRegistry == null) {
            return;
        }
        if (resin != null) {
            crateRegistry.registerCrate(resin);
        }
        if (rubber != null) {
            crateRegistry.registerCrate(rubber);
        }
        if ((scrap = IC2Items.getItem((String)"crafting", (String)"scrap")) != null) {
            crateRegistry.registerCrate(scrap);
        }
        if ((uuMatter = IC2Items.getItem((String)"misc_resource", (String)"matter")) != null) {
            crateRegistry.registerCrate(uuMatter);
        }
        if ((silver = IC2Items.getItem((String)"ingot", (String)"silver")) != null) {
            crateRegistry.registerCrate(silver);
        }
        if ((brass = IC2Items.getItem((String)"ingot", (String)"bronze")) != null) {
            crateRegistry.registerCrate(brass);
        }
    }

    @Override
    @Optional.Method(modid="IC2")
    public void registerRecipes() {
        BlockRegistryEnergy energyBlocks;
        int bogEarthOutputCan;
        ItemStack waterCell;
        FluidStack biogas;
        ItemRegistryApiculture beeItems;
        ItemStack bioChaff;
        ItemStack plantBall;
        ItemRegistryCore coreItems = PluginCore.items;
        if (rubber != null) {
            for (Object rubberOreDict : RecipeUtil.getOreDictRecipeEquivalents(rubber)) {
                RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), coreItems.tubes.get(EnumElectronTube.RUBBER, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), rubberOreDict});
            }
        }
        if ((plantBall = IC2Items.getItem((String)"crafting", (String)"plant_ball")) != null) {
            RecipeUtil.addFermenterRecipes(plantBall, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat") * 9, Fluids.BIOMASS);
        }
        if ((bioChaff = IC2Items.getItem((String)"crafting", (String)"bio_chaff")) != null) {
            RecipeUtil.addFermenterRecipes(bioChaff, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat") * 9, Fluids.BIOMASS);
        }
        if ((beeItems = PluginApiculture.items) != null) {
            if (resin != null) {
                RecipeManagers.centrifugeManager.addRecipe(20, beeItems.propolis.get(EnumPropolis.NORMAL, 1), (Map<ItemStack, Float>)ImmutableMap.of((Object)resin, (Object)Float.valueOf(1.0f)));
            } else {
                Log.info("Missing IC2 resin, skipping centrifuge recipe for propolis to resin.", new Object[0]);
            }
        }
        if (rubberSapling != null) {
            RecipeUtil.addFermenterRecipes(rubberSapling, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.sapling"), Fluids.BIOMASS);
        } else {
            Log.info("Missing IC2 rubber sapling, skipping fermenter recipe for converting rubber sapling to biomass.", new Object[0]);
        }
        if (rubberSapling != null && resin != null) {
            String saplingName = ItemStackUtil.getBlockNameFromRegistryAsSting(ItemStackUtil.getBlock(rubberSapling));
            String resinName = ItemStackUtil.getItemNameFromRegistryAsString(resin.func_77973_b());
            String imc = String.format("farmArboreal@%s.%s.%s.%s", saplingName, rubberSapling.func_77952_i(), resinName, resin.func_77952_i());
            Log.trace("Sending IMC '%s'.", imc);
            FMLInterModComms.sendMessage((String)"forestry", (String)"add-farmable-sapling", (String)imc);
        }
        if (ForestryAPI.enabledPlugins.contains("forestry.energy") && (biogas = FluidRegistry.getFluidStack((String)"ic2biogas", (int)1000)) != null) {
            int burnDuration = Math.round(2500.0f * ForestryAPI.activeMode.getFloatSetting("fuel.biomass.biogas"));
            EngineBronzeFuel bronzeFuel = new EngineBronzeFuel(Fluids.BIOMASS.getFluid(), 50, burnDuration, 1);
            FuelManager.bronzeEngineFuel.put(biogas.getFluid(), bronzeFuel);
        }
        if ((waterCell = IC2Items.getItem((String)"fluid_cell", (String)"water")) != null && (bogEarthOutputCan = ForestryAPI.activeMode.getIntegerSetting("recipe.output.bogearth.can")) > 0) {
            ItemStack bogEarthCan = PluginCore.blocks.bogEarth.get(BlockBogEarth.SoilType.BOG_EARTH, bogEarthOutputCan);
            RecipeUtil.addRecipe(bogEarthCan, "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), waterCell, Character.valueOf('Y'), "sand");
        }
        ICircuitLayout layout = ChipsetManager.circuitRegistry.getLayout("forestry.engine.tin");
        ChipsetManager.solderManager.addRecipe(layout, coreItems.tubes.get(EnumElectronTube.COPPER, 1), Circuit.energyElectricChoke1);
        ChipsetManager.solderManager.addRecipe(layout, coreItems.tubes.get(EnumElectronTube.TIN, 1), Circuit.energyElectricBoost1);
        ChipsetManager.solderManager.addRecipe(layout, coreItems.tubes.get(EnumElectronTube.BRONZE, 1), Circuit.energyElectricBoost2);
        ChipsetManager.solderManager.addRecipe(layout, coreItems.tubes.get(EnumElectronTube.IRON, 1), Circuit.energyElectricEfficiency1);
        if (ForestryAPI.enabledPlugins.contains("forestry.farming")) {
            if (resin != null && rubberWood != null) {
                ICircuitLayout layoutManual = ChipsetManager.circuitRegistry.getLayout("forestry.farms.manual");
                ChipsetManager.solderManager.addRecipe(layoutManual, coreItems.tubes.get(EnumElectronTube.RUBBER, 1), Circuit.farmRubberManual);
            }
            Farmables.farmables.get((Object)"farmOrchard").add(new FarmableBasicIC2Crop());
        }
        if ((energyBlocks = PluginEnergy.blocks) != null) {
            RecipeUtil.addRecipe(this.blocks.generator, "X#X", "XYX", "X#X", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "ingotGold", Character.valueOf('Y'), coreItems.sturdyCasing);
            RecipeUtil.addRecipe(this.blocks.electricalEngine, "###", " X ", "YVY", Character.valueOf('#'), "ingotTin", Character.valueOf('X'), "blockGlass", Character.valueOf('Y'), "gearTin", Character.valueOf('V'), Blocks.field_150331_J);
        }
    }

    @Override
    public void registerItemsAndBlocks() {
        super.registerItemsAndBlocks();
        this.blocks = new BlockRegistryIC2();
    }
}

