/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.genetics.ISpeciesRoot;
import forestry.core.gui.ContainerNaturalistInventory;
import forestry.core.gui.GuiHandler;
import forestry.core.gui.GuiNaturalistInventory;
import forestry.core.gui.IPagedInventory;
import forestry.core.inventory.InventoryNaturalistChest;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.tiles.TileBase;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;

public abstract class TileNaturalistChest
extends TileBase
implements IPagedInventory {
    private static final float lidAngleVariationPerTick = 0.1f;
    public static final AxisAlignedBB chestBoundingBox = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    private final ISpeciesRoot speciesRoot;
    public float lidAngle;
    public float prevLidAngle;
    private int numPlayersUsing;

    public TileNaturalistChest(ISpeciesRoot speciesRoot) {
        super("naturalist.chest");
        this.speciesRoot = speciesRoot;
        this.setInternalInventory(new InventoryNaturalistChest(this, speciesRoot));
    }

    public void increaseNumPlayersUsing() {
        ++this.numPlayersUsing;
        this.setNeedsNetworkUpdate();
    }

    public void decreaseNumPlayersUsing() {
        --this.numPlayersUsing;
        if (this.numPlayersUsing < 0) {
            this.numPlayersUsing = 0;
        }
        this.setNeedsNetworkUpdate();
    }

    @Override
    protected void updateClientSide() {
        this.updates();
    }

    @Override
    protected void updateServerSide() {
        this.updates();
    }

    private void updates() {
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.playLidSound("random.chestopen");
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float oldAngle = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            this.lidAngle = Math.max(Math.min(this.lidAngle, 1.0f), 0.0f);
            if (this.lidAngle < 0.5f && oldAngle >= 0.5f) {
                this.playLidSound("random.chestclosed");
            }
        }
    }

    private void playLidSound(String sound) {
        this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    @Override
    public void flipPage(EntityPlayer player, short page) {
        GuiHandler.openGui(player, this, page);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeInt(this.numPlayersUsing);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.numPlayersUsing = data.readInt();
    }

    @Override
    public Object getGui(EntityPlayer player, int page) {
        ContainerNaturalistInventory container = new ContainerNaturalistInventory(player.field_71071_by, this, page);
        return new GuiNaturalistInventory(this.speciesRoot, player, container, this, page, 5);
    }

    @Override
    public Object getContainer(EntityPlayer player, int page) {
        return new ContainerNaturalistInventory(player.field_71071_by, this, page);
    }
}

