/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.lepidopterology.entities;

public class AIButterflyRise extends AIButterflyMovement {

	public AIButterflyRise(EntityButterfly entity) {
		super(entity);
		func_75248_a(1);
	}

	@Override
	public boolean func_75250_a() {
		if (entity.getDestination() != null) {
			return false;
		}

		if (!entity.field_70123_F && entity.func_70681_au().nextInt(64) != 0) {
			return false;
		}

		flightTarget = getRandomDestinationUpwards();
		if (flightTarget == null) {
			if (entity.getState().doesMovement) {
				entity.setState(EnumButterflyState.HOVER);
			}
			return false;
		}

		entity.setDestination(flightTarget);
		entity.setState(EnumButterflyState.RISING);
		return true;
	}

	@Override
	public boolean func_75253_b() {
		if (entity.getState() != EnumButterflyState.RISING) {
			return false;
		}
		if (flightTarget == null) {
			return false;
		}
		// Abort if the flight target changed on us.
		if (entity.getDestination() == null || !entity.getDestination().equals(flightTarget)) {
			return false;
		}

		// Continue if we have not yet reached the destination.
		if (entity.getDestination().func_72436_e(entity.func_174791_d()) > 2.0f) {
			return true;
		}

		entity.setDestination(null);
		return false;
	}

	@Override
	public void func_75246_d() {
		if (entity.func_70090_H()) {
			flightTarget = getRandomDestinationUpwards();
		} else if (entity.field_70124_G && entity.func_70681_au().nextInt(62) == 0) {
			flightTarget = null;
		}

		entity.setDestination(flightTarget);
		entity.changeExhaustion(1);
	}
}
