/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.genetics.BeeGenome;
import forestry.core.config.Config;
import forestry.core.genetics.alleles.AlleleBoolean;
import forestry.core.gui.GuiAlyzer;
import forestry.core.gui.TextLayoutHelper;
import forestry.core.gui.widgets.ItemStackWidget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BeeAlyzerPlugin
implements IAlyzerPlugin {
    public static final BeeAlyzerPlugin INSTANCE = new BeeAlyzerPlugin();
    protected final Map<String, ItemStack> iconStacks = new HashMap<String, ItemStack>();

    private BeeAlyzerPlugin() {
        ArrayList<ItemStack> beeList = new ArrayList<ItemStack>();
        PluginApiculture.items.beeDroneGE.addCreativeItems(beeList, false);
        for (ItemStack beeStack : beeList) {
            IAlleleBeeSpecies species = BeeGenome.getSpecies(beeStack);
            if (species == null) continue;
            this.iconStacks.put(species.getUID(), beeStack);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAnalyticsPage1(GuiAlyzer gui, ItemStack itemStack) {
        IBee bee = BeeManager.beeRoot.getMember(itemStack);
        if (bee == null) {
            return;
        }
        EnumBeeType type = BeeManager.beeRoot.getType(itemStack);
        TextLayoutHelper textLayout = gui.getTextLayout();
        textLayout.startPage(12, 90, 155);
        textLayout.drawLine(Translator.translateToLocal("for.gui.active"), 90);
        textLayout.drawLine(Translator.translateToLocal("for.gui.inactive"), 155);
        textLayout.newLine();
        textLayout.newLine();
        String customPrimaryBeeKey = "for.bees.custom.beealyzer." + type.getName() + "." + bee.getGenome().getPrimary().getUnlocalizedName().replace("bees.species.", "");
        String customSecondaryBeeKey = "for.bees.custom.beealyzer." + type.getName() + "." + bee.getGenome().getSecondary().getUnlocalizedName().replace("bees.species.", "");
        gui.drawSpeciesRow(Translator.translateToLocal("for.gui.species"), bee, EnumBeeChromosome.SPECIES, GuiAlyzer.checkCustomName(customPrimaryBeeKey), GuiAlyzer.checkCustomName(customSecondaryBeeKey));
        textLayout.newLine();
        gui.drawChromosomeRow(Translator.translateToLocal("for.gui.lifespan"), bee, EnumBeeChromosome.LIFESPAN);
        textLayout.newLine();
        gui.drawChromosomeRow(Translator.translateToLocal("for.gui.speed"), bee, EnumBeeChromosome.SPEED);
        textLayout.newLine();
        gui.drawChromosomeRow(Translator.translateToLocal("for.gui.pollination"), bee, EnumBeeChromosome.FLOWERING);
        textLayout.newLine();
        gui.drawChromosomeRow(Translator.translateToLocal("for.gui.flowers"), bee, EnumBeeChromosome.FLOWER_PROVIDER);
        textLayout.newLine();
        textLayout.drawLine(Translator.translateToLocal("for.gui.fertility"), 12);
        IAlleleInteger primaryFertility = (IAlleleInteger)bee.getGenome().getActiveAllele(EnumBeeChromosome.FERTILITY);
        IAlleleInteger secondaryFertility = (IAlleleInteger)bee.getGenome().getInactiveAllele(EnumBeeChromosome.FERTILITY);
        gui.drawFertilityInfo(primaryFertility.getValue(), 90, gui.getColorCoding(primaryFertility.isDominant()), 0);
        gui.drawFertilityInfo(secondaryFertility.getValue(), 155, gui.getColorCoding(secondaryFertility.isDominant()), 0);
        textLayout.newLine();
        gui.drawChromosomeRow(Translator.translateToLocal("for.gui.area"), bee, EnumBeeChromosome.TERRITORY);
        textLayout.newLine();
        gui.drawChromosomeRow(Translator.translateToLocal("for.gui.effect"), bee, EnumBeeChromosome.EFFECT);
        textLayout.newLine();
        textLayout.endPage();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAnalyticsPage2(GuiAlyzer gui, ItemStack itemStack) {
        String displayText;
        String nocturnal1;
        String diurnal1;
        String nocturnal0;
        String diurnal0;
        IBee bee = BeeManager.beeRoot.getMember(itemStack);
        if (bee == null) {
            return;
        }
        EnumBeeType type = BeeManager.beeRoot.getType(itemStack);
        TextLayoutHelper textLayout = gui.getTextLayout();
        textLayout.startPage(12, 90, 155);
        textLayout.drawLine(Translator.translateToLocal("for.gui.active"), 90);
        textLayout.drawLine(Translator.translateToLocal("for.gui.inactive"), 155);
        textLayout.newLine();
        gui.drawRow(Translator.translateToLocal("for.gui.climate"), AlleleManager.climateHelper.toDisplay(bee.getGenome().getPrimary().getTemperature()), AlleleManager.climateHelper.toDisplay(bee.getGenome().getSecondary().getTemperature()), bee, EnumBeeChromosome.SPECIES);
        textLayout.newLine();
        IAlleleTolerance tempToleranceActive = (IAlleleTolerance)bee.getGenome().getActiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE);
        IAlleleTolerance tempToleranceInactive = (IAlleleTolerance)bee.getGenome().getInactiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE);
        textLayout.drawLine("  " + Translator.translateToLocal("for.gui.tolerance"), 12);
        gui.drawToleranceInfo(tempToleranceActive, 90);
        gui.drawToleranceInfo(tempToleranceInactive, 155);
        textLayout.newLine(16);
        gui.drawRow(Translator.translateToLocal("for.gui.humidity"), AlleleManager.climateHelper.toDisplay(bee.getGenome().getPrimary().getHumidity()), AlleleManager.climateHelper.toDisplay(bee.getGenome().getSecondary().getHumidity()), bee, EnumBeeChromosome.SPECIES);
        textLayout.newLine();
        IAlleleTolerance humidToleranceActive = (IAlleleTolerance)bee.getGenome().getActiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE);
        IAlleleTolerance humidToleranceInactive = (IAlleleTolerance)bee.getGenome().getInactiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE);
        textLayout.drawLine("  " + Translator.translateToLocal("for.gui.tolerance"), 12);
        gui.drawToleranceInfo(humidToleranceActive, 90);
        gui.drawToleranceInfo(humidToleranceInactive, 155);
        textLayout.newLine(16);
        String yes = Translator.translateToLocal("for.yes");
        String no = Translator.translateToLocal("for.no");
        if (bee.getGenome().getNeverSleeps()) {
            nocturnal0 = diurnal0 = yes;
        } else {
            nocturnal0 = bee.getGenome().getPrimary().isNocturnal() ? yes : no;
            String string = diurnal0 = !bee.getGenome().getPrimary().isNocturnal() ? yes : no;
        }
        if (((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumBeeChromosome.NEVER_SLEEPS)).getValue()) {
            nocturnal1 = diurnal1 = yes;
        } else {
            nocturnal1 = bee.getGenome().getSecondary().isNocturnal() ? yes : no;
            diurnal1 = !bee.getGenome().getSecondary().isNocturnal() ? yes : no;
        }
        textLayout.drawLine(Translator.translateToLocal("for.gui.diurnal"), 12);
        textLayout.drawLine(diurnal0, 90, gui.getColorCoding(false));
        textLayout.drawLine(diurnal1, 155, gui.getColorCoding(false));
        textLayout.newLineCompressed();
        textLayout.drawLine(Translator.translateToLocal("for.gui.nocturnal"), 12);
        textLayout.drawLine(nocturnal0, 90, gui.getColorCoding(false));
        textLayout.drawLine(nocturnal1, 155, gui.getColorCoding(false));
        textLayout.newLineCompressed();
        String primary = StringUtil.readableBoolean(bee.getGenome().getToleratesRain(), yes, no);
        String secondary = StringUtil.readableBoolean(((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumBeeChromosome.TOLERATES_RAIN)).getValue(), yes, no);
        gui.drawRow(Translator.translateToLocal("for.gui.flyer"), primary, secondary, bee, EnumBeeChromosome.TOLERATES_RAIN);
        textLayout.newLineCompressed();
        primary = StringUtil.readableBoolean(bee.getGenome().getCaveDwelling(), yes, no);
        secondary = StringUtil.readableBoolean(((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumBeeChromosome.CAVE_DWELLING)).getValue(), yes, no);
        gui.drawRow(Translator.translateToLocal("for.gui.cave"), primary, secondary, bee, EnumBeeChromosome.CAVE_DWELLING);
        textLayout.newLine();
        if (type == EnumBeeType.PRINCESS || type == EnumBeeType.QUEEN) {
            String displayTextKey = "for.bees.stock.pristine";
            if (!bee.isNatural()) {
                displayTextKey = "for.bees.stock.ignoble";
            }
            displayText = Translator.translateToLocal(displayTextKey);
            textLayout.drawCenteredLine(displayText, 8, 208, gui.getFontColor().get("gui.beealyzer.binomial"));
        }
        if (bee.getGeneration() >= 0) {
            textLayout.newLineCompressed();
            displayText = Translator.translateToLocalFormatted("for.gui.beealyzer.generations", bee.getGeneration());
            textLayout.drawCenteredLine(displayText, 8, 208, gui.getFontColor().get("gui.beealyzer.binomial"));
        }
        textLayout.endPage();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAnalyticsPage3(GuiAlyzer gui, ItemStack itemStack) {
        IBee bee = BeeManager.beeRoot.getMember(itemStack);
        if (bee == null) {
            return;
        }
        TextLayoutHelper textLayout = gui.getTextLayout();
        WidgetManager widgetManager = gui.getWidgetManager();
        textLayout.startPage(12, 90, 155);
        textLayout.drawLine(Translator.translateToLocal("for.gui.beealyzer.produce") + ":", 12);
        textLayout.newLine();
        int x = 12;
        for (ItemStack stack : bee.getProduceList()) {
            widgetManager.add(new ItemStackWidget(widgetManager, x, textLayout.getLineY(), stack));
            if ((x += 18) <= 148) continue;
            x = 12;
            textLayout.newLine();
        }
        textLayout.newLine();
        textLayout.newLine();
        textLayout.newLine();
        textLayout.newLine();
        textLayout.drawLine(Translator.translateToLocal("for.gui.beealyzer.specialty") + ":", 12);
        textLayout.newLine();
        x = 12;
        for (ItemStack stack : bee.getSpecialtyList()) {
            widgetManager.add(new ItemStackWidget(widgetManager, x, textLayout.getLineY(), stack));
            if ((x += 18) <= 148) continue;
            x = 12;
            textLayout.newLine();
        }
        textLayout.endPage();
    }

    @Override
    public Map<String, ItemStack> getIconStacks() {
        return this.iconStacks;
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"beealyzer");
    }
}

