/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import java.text.DateFormatSymbols;
import java.util.Calendar;

public class DayMonth {
    public final int day;
    public final int month;

    public DayMonth() {
        this.day = Calendar.getInstance().get(5);
        this.month = Calendar.getInstance().get(2) + 1;
    }

    public DayMonth(int day, int month) {
        this.day = day;
        this.month = month;
    }

    public boolean between(DayMonth start, DayMonth end) {
        if (this.equals(start) || this.equals(end)) {
            return true;
        }
        if (start.month > end.month) {
            return this.after(start) || this.before(end);
        }
        return this.after(start) && this.before(end);
    }

    public boolean before(DayMonth other) {
        if (other.month > this.month) {
            return true;
        }
        if (other.month < this.month) {
            return false;
        }
        return this.day < other.day;
    }

    public boolean after(DayMonth other) {
        if (other.month < this.month) {
            return true;
        }
        if (other.month > this.month) {
            return false;
        }
        return this.day > other.day;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.day;
        hash = 89 * hash + this.month;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DayMonth other = (DayMonth)obj;
        if (this.day != other.day) {
            return false;
        }
        return this.month == other.month;
    }

    public String toString() {
        String monthName = new DateFormatSymbols().getMonths()[this.month - 1];
        return monthName + ' ' + this.day;
    }
}

