/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import com.google.common.collect.ImmutableMap;
import forestry.api.circuits.ChipsetManager;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.multiblock.MultiblockManager;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.core.ClimateManager;
import forestry.core.IPickupHandler;
import forestry.core.ISaveEventHandler;
import forestry.core.PickupHandlerCore;
import forestry.core.PluginFluids;
import forestry.core.SaveEventHandlerCore;
import forestry.core.blocks.BlockBogEarth;
import forestry.core.blocks.BlockRegistryCore;
import forestry.core.blocks.EnumResourceType;
import forestry.core.circuits.CircuitRegistry;
import forestry.core.circuits.SolderManager;
import forestry.core.commands.CommandPlugins;
import forestry.core.commands.RootCommand;
import forestry.core.config.Config;
import forestry.core.fluids.Fluids;
import forestry.core.genetics.alleles.AlleleFactory;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.AlleleRegistry;
import forestry.core.items.EnumContainerType;
import forestry.core.items.ItemRegistryCore;
import forestry.core.loot.functions.SetSpeciesNBT;
import forestry.core.models.ModelManager;
import forestry.core.multiblock.MultiblockLogicFactory;
import forestry.core.network.IPacketRegistry;
import forestry.core.network.PacketRegistryCore;
import forestry.core.proxy.Proxies;
import forestry.core.recipes.RecipeUtil;
import forestry.core.render.TextureManager;
import forestry.core.utils.ClimateUtil;
import forestry.core.utils.ForestryModEnvWarningCallable;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@ForestryPlugin(pluginID="forestry.core", name="Core", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.core.description")
public class PluginCore
extends BlankForestryPlugin {
    public static final RootCommand rootCommand = new RootCommand();
    public static ItemRegistryCore items;
    public static BlockRegistryCore blocks;

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    @Override
    @Nonnull
    public Set<String> getDependencyUids() {
        return Collections.emptySet();
    }

    @Override
    public void setupAPI() {
        ChipsetManager.solderManager = new SolderManager();
        ChipsetManager.circuitRegistry = new CircuitRegistry();
        AlleleRegistry alleleRegistry = new AlleleRegistry();
        AlleleManager.alleleRegistry = alleleRegistry;
        AlleleManager.climateHelper = new ClimateUtil();
        AlleleManager.alleleFactory = new AlleleFactory();
        alleleRegistry.initialize();
        AlleleHelper.instance = new AlleleHelper();
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new SetSpeciesNBT.Serializer());
        MultiblockManager.logicFactory = new MultiblockLogicFactory();
        ForestryAPI.climateManager = new ClimateManager();
    }

    @Override
    public void registerItemsAndBlocks() {
        items = new ItemRegistryCore();
        blocks = new BlockRegistryCore();
    }

    @Override
    public void preInit() {
        super.preInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
        rootCommand.addChildCommand(new CommandPlugins());
    }

    @Override
    public void doInit() {
        super.doInit();
        PluginCore.blocks.analyzer.init();
        PluginCore.blocks.escritoire.init();
        ForestryModEnvWarningCallable.register();
        AlleleHelper.instance.init();
        Proxies.render.initRendering();
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerCore();
    }

    @Override
    public void registerCrates() {
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        crateRegistry.registerCrate(PluginCore.items.peat);
        crateRegistry.registerCrate(PluginCore.items.apatite);
        crateRegistry.registerCrate(PluginCore.items.fertilizerCompound);
        crateRegistry.registerCrate(PluginCore.items.mulch);
        crateRegistry.registerCrate(PluginCore.items.phosphor);
        crateRegistry.registerCrate(PluginCore.items.ash);
        crateRegistry.registerCrate("ingotTin");
        crateRegistry.registerCrate("ingotCopper");
        crateRegistry.registerCrate("ingotBronze");
        crateRegistry.registerCrate(PluginCore.blocks.humus);
        crateRegistry.registerCrate(PluginCore.blocks.bogEarth.get(BlockBogEarth.SoilType.BOG_EARTH, 1));
        crateRegistry.registerCrate("cropWheat");
        crateRegistry.registerCrate(Items.field_151106_aX);
        crateRegistry.registerCrate("dustRedstone");
        crateRegistry.registerCrate(new ItemStack(Items.field_151100_aR, 1, 4));
        crateRegistry.registerCrate("sugarcane");
        crateRegistry.registerCrate(Items.field_151119_aD);
        crateRegistry.registerCrate("dustGlowstone");
        crateRegistry.registerCrate(Items.field_151034_e);
        crateRegistry.registerCrate(new ItemStack(Items.field_151075_bm));
        crateRegistry.registerCrate(new ItemStack(Items.field_151044_h, 1, 1));
        crateRegistry.registerCrate(new ItemStack(Items.field_151044_h, 1, 0));
        crateRegistry.registerCrate(Items.field_151014_N);
        crateRegistry.registerCrate("cropPotato");
        crateRegistry.registerCrate("cropCarrot");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150364_r, 1, 0));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150364_r, 1, 1));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150364_r, 1, 2));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150364_r, 1, 3));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150363_s, 1, 0));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150363_s, 1, 1));
        crateRegistry.registerCrate("cobblestone");
        crateRegistry.registerCrate("dirt");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150346_d, 1, 2));
        crateRegistry.registerCrate("stone");
        crateRegistry.registerCrate("stoneGranite");
        crateRegistry.registerCrate("stoneDiorite");
        crateRegistry.registerCrate("stoneAndesite");
        crateRegistry.registerCrate("blockPrismarine");
        crateRegistry.registerCrate("blockPrismarineBrick");
        crateRegistry.registerCrate("blockPrismarineDark");
        crateRegistry.registerCrate(Blocks.field_150336_V);
        crateRegistry.registerCrate("blockCactus");
        crateRegistry.registerCrate(new ItemStack((Block)Blocks.field_150354_m, 1, 0));
        crateRegistry.registerCrate(new ItemStack((Block)Blocks.field_150354_m, 1, 1));
        crateRegistry.registerCrate("obsidian");
        crateRegistry.registerCrate("netherrack");
        crateRegistry.registerCrate(Blocks.field_150425_aM);
        crateRegistry.registerCrate(Blocks.field_150322_A);
        crateRegistry.registerCrate(Blocks.field_150385_bj);
        crateRegistry.registerCrate((Block)Blocks.field_150391_bh);
        crateRegistry.registerCrate("gravel");
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150345_g, 1, 0));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150345_g, 1, 1));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150345_g, 1, 2));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150345_g, 1, 3));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150345_g, 1, 4));
        crateRegistry.registerCrate(new ItemStack(Blocks.field_150345_g, 1, 5));
    }

    @Override
    public void registerRecipes() {
        int bogEarthOutputCan;
        int bogEarthOutputBucket;
        int humusFertilizerAmount;
        int humusCompostAmount;
        int fertilizerAshAmount;
        int fertilizerApatiteAmount;
        int compostAshAmount;
        RecipeUtil.addSmelting(PluginCore.blocks.resources.get(EnumResourceType.APATITE, 1), PluginCore.items.apatite, 0.5f);
        RecipeUtil.addSmelting(PluginCore.blocks.resources.get(EnumResourceType.COPPER, 1), PluginCore.items.ingotCopper, 0.5f);
        RecipeUtil.addSmelting(PluginCore.blocks.resources.get(EnumResourceType.TIN, 1), PluginCore.items.ingotTin, 0.5f);
        RecipeUtil.addSmelting(new ItemStack((Item)PluginCore.items.peat), PluginCore.items.ash, 0.0f);
        if (Config.isCraftingBronzeEnabled()) {
            ItemStack ingotBronze = PluginCore.items.ingotBronze.func_77946_l();
            ingotBronze.field_77994_a = 4;
            RecipeUtil.addShapelessRecipe(ingotBronze, "ingotTin", "ingotCopper", "ingotCopper", "ingotCopper");
        }
        RecipeUtil.addRecipe(PluginCore.items.sturdyCasing, "###", "# #", "###", Character.valueOf('#'), "ingotBronze");
        int canAmount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.can");
        ItemStack canOutput = PluginFluids.items.canEmpty.getItemStack(canAmount);
        RecipeUtil.addRecipe(canOutput, " # ", "# #", Character.valueOf('#'), "ingotTin");
        List stoneGear = OreDictionary.getOres((String)"gearStone");
        String gearCenter = !stoneGear.isEmpty() ? "gearStone" : "ingotCopper";
        RecipeUtil.addRecipe(PluginCore.items.gearBronze, " # ", "#X#", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), gearCenter);
        RecipeUtil.addRecipe(PluginCore.items.gearCopper, " # ", "#X#", " # ", Character.valueOf('#'), "ingotCopper", Character.valueOf('X'), gearCenter);
        RecipeUtil.addRecipe(PluginCore.items.gearTin, " # ", "#X#", " # ", Character.valueOf('#'), "ingotTin", Character.valueOf('X'), gearCenter);
        RecipeUtil.addRecipe(PluginCore.items.bronzePickaxe, " X ", " X ", "###", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        RecipeUtil.addRecipe(PluginCore.items.bronzeShovel, " X ", " X ", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        RecipeUtil.addShapelessRecipe(PluginCore.items.kitPickaxe, PluginCore.items.bronzePickaxe, PluginCore.items.carton);
        RecipeUtil.addShapelessRecipe(PluginCore.items.kitShovel, PluginCore.items.bronzeShovel, PluginCore.items.carton);
        RecipeUtil.addRecipe((Item)PluginCore.items.spectacles, " X ", "Y Y", Character.valueOf('X'), "ingotBronze", Character.valueOf('Y'), "paneGlass");
        RecipeUtil.addRecipe(PluginCore.items.wrench, "# #", " # ", " # ", Character.valueOf('#'), "ingotBronze");
        if (ForestryAPI.enabledPlugins.contains("forestry.factory")) {
            RecipeManagers.carpenterManager.addRecipe(100, Fluids.WATER.getFluid(2000), null, PluginCore.items.portableAlyzer.getItemStack(), "X#X", "X#X", "RDR", Character.valueOf('#'), "paneGlass", Character.valueOf('X'), "ingotTin", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond");
        } else {
            RecipeUtil.addRecipe(PluginCore.items.portableAlyzer.getItemStack(), "X#X", "X#X", "RDR", Character.valueOf('#'), "paneGlass", Character.valueOf('X'), "ingotTin", Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond");
        }
        RecipeUtil.addRecipe(PluginCore.blocks.analyzer, "XTX", " Y ", "X X", Character.valueOf('Y'), PluginCore.items.sturdyCasing, Character.valueOf('T'), PluginCore.items.portableAlyzer, Character.valueOf('X'), "ingotBronze");
        int compostWheatAmount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.compost.wheat");
        if (compostWheatAmount > 0) {
            ItemStack compost = PluginCore.items.fertilizerBio.getItemStack(compostWheatAmount);
            RecipeUtil.addRecipe(compost, " X ", "X#X", " X ", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), "cropWheat");
        }
        if ((compostAshAmount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.compost.ash")) > 0) {
            ItemStack compost = PluginCore.items.fertilizerBio.getItemStack(compostAshAmount);
            RecipeUtil.addRecipe(compost, " X ", "X#X", " X ", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), "dustAsh");
        }
        if ((fertilizerApatiteAmount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.fertilizer.apatite")) > 0) {
            ItemStack fertilizer = PluginCore.items.fertilizerCompound.getItemStack(fertilizerApatiteAmount);
            RecipeUtil.addRecipe(fertilizer, " # ", " X ", " # ", Character.valueOf('#'), "sand", Character.valueOf('X'), "gemApatite");
        }
        if ((fertilizerAshAmount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.fertilizer.ash")) > 0) {
            ItemStack fertilizer = PluginCore.items.fertilizerCompound.getItemStack(fertilizerAshAmount);
            RecipeUtil.addRecipe(fertilizer, "###", "#X#", "###", Character.valueOf('#'), "dustAsh", Character.valueOf('X'), "gemApatite");
        }
        if ((humusCompostAmount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.humus.compost")) > 0) {
            ItemStack humus = new ItemStack((Block)PluginCore.blocks.humus, humusCompostAmount);
            RecipeUtil.addRecipe(humus, "###", "#X#", "###", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), PluginCore.items.fertilizerBio);
        }
        if ((humusFertilizerAmount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.humus.fertilizer")) > 0) {
            ItemStack humus = new ItemStack((Block)PluginCore.blocks.humus, humusFertilizerAmount);
            RecipeUtil.addRecipe(humus, "###", "#X#", "###", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), PluginCore.items.fertilizerCompound);
        }
        if ((bogEarthOutputBucket = ForestryAPI.activeMode.getIntegerSetting("recipe.output.bogearth.bucket")) > 0) {
            ItemStack bogEarth = PluginCore.blocks.bogEarth.get(BlockBogEarth.SoilType.BOG_EARTH, bogEarthOutputBucket);
            RecipeUtil.addRecipe(bogEarth, "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), Items.field_151131_as, Character.valueOf('Y'), "sand");
        }
        if ((bogEarthOutputCan = ForestryAPI.activeMode.getIntegerSetting("recipe.output.bogearth.can")) > 0) {
            ItemStack bogEarth = PluginCore.blocks.bogEarth.get(BlockBogEarth.SoilType.BOG_EARTH, bogEarthOutputCan);
            ItemStack canWater = PluginFluids.items.getContainer(EnumContainerType.CAN, Fluids.WATER);
            ItemStack waxCapsuleWater = PluginFluids.items.getContainer(EnumContainerType.CAPSULE, Fluids.WATER);
            ItemStack refractoryWater = PluginFluids.items.getContainer(EnumContainerType.REFRACTORY, Fluids.WATER);
            RecipeUtil.addRecipe(bogEarth, "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), canWater, Character.valueOf('Y'), "sand");
            RecipeUtil.addRecipe(bogEarth, "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), waxCapsuleWater, Character.valueOf('Y'), "sand");
            RecipeUtil.addRecipe(bogEarth, "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), refractoryWater, Character.valueOf('Y'), "sand");
        }
        RecipeUtil.addRecipe(new ItemStack(Items.field_151007_F), "#", "#", "#", Character.valueOf('#'), PluginCore.items.craftingMaterial.getSilkWisp());
        RecipeUtil.addRecipe(PluginCore.items.pipette, "  #", " X ", "X  ", Character.valueOf('X'), "paneGlass", Character.valueOf('#'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE));
        RecipeUtil.addRecipe(PluginCore.blocks.resourceStorageApatite, "###", "###", "###", Character.valueOf('#'), "gemApatite");
        RecipeUtil.addShapelessRecipe(new ItemStack((Item)PluginCore.items.apatite, 9), "blockApatite");
        RecipeUtil.addRecipe(PluginCore.blocks.resourceStorageCopper, "###", "###", "###", Character.valueOf('#'), "ingotCopper");
        ItemStack ingotCopper = PluginCore.items.ingotCopper.func_77946_l();
        ingotCopper.field_77994_a = 9;
        RecipeUtil.addShapelessRecipe(ingotCopper, "blockCopper");
        RecipeUtil.addRecipe(PluginCore.blocks.resourceStorageTin, "###", "###", "###", Character.valueOf('#'), "ingotTin");
        ItemStack ingotTin = PluginCore.items.ingotTin.func_77946_l();
        ingotTin.field_77994_a = 9;
        RecipeUtil.addShapelessRecipe(ingotTin, "blockTin");
        RecipeUtil.addRecipe(PluginCore.blocks.resourceStorageBronze, "###", "###", "###", Character.valueOf('#'), "ingotBronze");
        ItemStack ingotBronze = PluginCore.items.ingotBronze.func_77946_l();
        ingotBronze.field_77994_a = 9;
        RecipeUtil.addShapelessRecipe(ingotBronze, "blockBronze");
        if (!ForestryAPI.enabledPlugins.contains("forestry.apiculture")) {
            RecipeManagers.centrifugeManager.addRecipe(5, new ItemStack(Items.field_151007_F), (Map<ItemStack, Float>)ImmutableMap.of((Object)PluginCore.items.craftingMaterial.getSilkWisp(), (Object)Float.valueOf(0.15f)));
        }
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryCore();
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return new PickupHandlerCore();
    }

    @Override
    public ICommand[] getConsoleCommands() {
        return new ICommand[]{rootCommand};
    }

    @Override
    public IFuelHandler getFuelHandler() {
        return new FuelHandler();
    }

    @Override
    public void getHiddenItems(List<ItemStack> hiddenItems) {
        hiddenItems.add(new ItemStack((Item)PluginCore.items.researchNote));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onBakeModel(ModelBakeEvent event) {
        ModelManager.getInstance().registerCustomModels(event);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(TextureStitchEvent.Pre event) {
        TextureManager.getInstance().registerSprites();
    }

    private static class FuelHandler
    implements IFuelHandler {
        private FuelHandler() {
        }

        public int getBurnTime(ItemStack fuel) {
            if (fuel != null && fuel.func_77973_b() == PluginCore.items.peat) {
                return 2000;
            }
            if (fuel != null && fuel.func_77973_b() == PluginCore.items.bituminousPeat) {
                return 4200;
            }
            return 0;
        }
    }
}

