/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumGrowthConditions;
import forestry.api.arboriculture.ITreeGenome;
import forestry.arboriculture.genetics.GrowthProvider;
import forestry.core.utils.Translator;
import java.util.EnumSet;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GrowthProviderTropical
extends GrowthProvider {
    @Override
    public EnumGrowthConditions getGrowthConditions(ITreeGenome genome, World world, BlockPos pos) {
        EnumGrowthConditions light = GrowthProviderTropical.getConditionFromLight(world, pos);
        EnumGrowthConditions moisture = GrowthProviderTropical.getConditionsFromRainfall(world, pos, Biomes.field_76782_w.func_76727_i(), 2.0f);
        float jungleTemperature = Biomes.field_76782_w.func_180626_a(pos);
        float desertTemperature = Biomes.field_76769_d.func_180626_a(pos);
        EnumGrowthConditions temperature = GrowthProviderTropical.getConditionsFromTemperature(world, pos, jungleTemperature, desertTemperature - 0.1f);
        EnumSet<EnumGrowthConditions> conditions = EnumSet.of(light, moisture, temperature);
        EnumGrowthConditions result = EnumGrowthConditions.HOSTILE;
        for (EnumGrowthConditions cond : conditions) {
            if (cond == EnumGrowthConditions.HOSTILE) {
                return EnumGrowthConditions.HOSTILE;
            }
            if (cond.ordinal() <= result.ordinal()) continue;
            result = cond;
        }
        return result;
    }

    @Override
    public String getDescription() {
        return Translator.translateToLocal("for.growth.tropical");
    }
}

