/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.core.fluids.Fluids;
import forestry.core.items.EnumContainerType;
import forestry.core.items.ItemFluidContainerForestry;
import forestry.core.items.ItemRegistry;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ItemRegistryFluids
extends ItemRegistry {
    public final ItemFluidContainerForestry canEmpty;
    public final ItemFluidContainerForestry waxCapsuleEmpty;
    public final ItemFluidContainerForestry refractoryEmpty;
    private final Map<EnumContainerType, ItemFluidContainerForestry> containers = new EnumMap<EnumContainerType, ItemFluidContainerForestry>(EnumContainerType.class);

    public ItemStack getContainer(EnumContainerType type, Fluids fluid) {
        ItemStack container = new ItemStack((Item)this.containers.get((Object)type));
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)container);
        fluidHandler.fill(fluid.getFluid(Integer.MAX_VALUE), true);
        return container;
    }

    public ItemRegistryFluids() {
        this.canEmpty = ItemRegistryFluids.registerItem(new ItemFluidContainerForestry(EnumContainerType.CAN), "can");
        this.waxCapsuleEmpty = ItemRegistryFluids.registerItem(new ItemFluidContainerForestry(EnumContainerType.CAPSULE), "capsule");
        this.refractoryEmpty = ItemRegistryFluids.registerItem(new ItemFluidContainerForestry(EnumContainerType.REFRACTORY), "refractory");
        this.containers.put(EnumContainerType.CAN, this.canEmpty);
        this.containers.put(EnumContainerType.CAPSULE, this.waxCapsuleEmpty);
        this.containers.put(EnumContainerType.REFRACTORY, this.refractoryEmpty);
    }
}

