/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.farming;

import com.google.common.collect.ImmutableSet;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import forestry.api.farming.FarmDirection;
import forestry.api.multiblock.IFarmComponent;

public class FarmHelper {

	public static final ImmutableSet<Block> bricks = ImmutableSet.of(
			Blocks.field_150336_V,
			Blocks.field_150417_aV,
			Blocks.field_150322_A,
			Blocks.field_150385_bj,
			Blocks.field_150371_ca
	);

	private static FarmDirection getOpposite(FarmDirection farmDirection) {
		EnumFacing forgeDirection = farmDirection.getFacing();
		EnumFacing forgeDirectionOpposite = forgeDirection.func_176734_d();
		return FarmDirection.getFarmDirection(forgeDirectionOpposite);
	}

	public static BlockPos getFarmMultiblockCorner(World world, BlockPos start, FarmDirection farmSide, FarmDirection layoutDirection) {
		BlockPos edge = getFarmMultiblockEdge(world, start, farmSide);
		return getFarmMultiblockEdge(world, edge, getOpposite(layoutDirection));
	}

	private static BlockPos getFarmMultiblockEdge(World world, BlockPos start, FarmDirection direction) {
		BlockPos.MutableBlockPos edge = new BlockPos.MutableBlockPos(start);

		while (world.func_175625_s(edge) instanceof IFarmComponent) {
			edge.func_189536_c(direction.getFacing());
		}

		FarmDirection oppositeDirection = getOpposite(direction);
		edge.func_189536_c(oppositeDirection.getFacing());
		return edge.func_185334_h();
	}

}
