/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.core.items.ItemForestry;
import forestry.core.proxy.Proxies;
import forestry.plugins.PluginManager;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public abstract class ItemRegistry {
    protected static <T extends Item> T registerItem(T item, String name) {
        if (PluginManager.getStage() != PluginManager.Stage.REGISTER) {
            throw new RuntimeException("Tried to register Item outside of REGISTER");
        }
        item.func_77655_b("for." + name);
        item.setRegistryName(name);
        GameRegistry.register(item);
        Proxies.common.registerItem(item);
        return item;
    }

    protected static void registerOreDict(String oreDictName, ItemStack itemStack) {
        OreDictionary.registerOre((String)oreDictName, (ItemStack)itemStack);
    }

    @Nonnull
    public static ItemStack createItemForOreName(String oreName) {
        ItemStack oreItem = new ItemStack((Item)ItemRegistry.registerItem(new ItemForestry(), oreName));
        OreDictionary.registerOre((String)oreName, (ItemStack)oreItem);
        return oreItem;
    }
}

