/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics.alleles;

import com.mojang.authlib.GameProfile;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IAlleleButterflySpeciesBuilder;
import forestry.api.lepidopterology.IButterflyRoot;
import forestry.core.genetics.alleles.AlleleSpecies;
import forestry.lepidopterology.render.TextureAtlasButterfly;
import java.awt.Color;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AlleleButterflySpecies
extends AlleleSpecies
implements IAlleleButterflySpecies,
IAlleleButterflySpeciesBuilder {
    private final String texture;
    private final String modID;
    private final Color serumColour;
    private float rarity = 0.1f;
    private float flightDistance = 5.0f;
    private boolean isActualNocturnal = false;
    private final EnumSet<BiomeDictionary.Type> spawnBiomes = EnumSet.noneOf(BiomeDictionary.Type.class);
    private final Map<ItemStack, Float> butterflyLoot = new HashMap<ItemStack, Float>();
    private final Map<ItemStack, Float> caterpillarLoot = new HashMap<ItemStack, Float>();

    public AlleleButterflySpecies(String uid, String unlocalizedName, String authority, String unlocalizedDescription, String modID, String texturePath, boolean isDominant, IClassification branch, String binomial, Color serumColour) {
        super(uid, unlocalizedName, authority, unlocalizedDescription, isDominant, branch, binomial);
        this.serumColour = serumColour;
        this.modID = modID;
        this.texture = texturePath;
    }

    @Override
    public IAlleleButterflySpecies build() {
        AlleleManager.alleleRegistry.registerAllele(this, EnumButterflyChromosome.SPECIES);
        return this;
    }

    @Override
    public IButterflyRoot getRoot() {
        return ButterflyManager.butterflyRoot;
    }

    @Override
    public AlleleButterflySpecies setRarity(float rarity) {
        this.rarity = rarity;
        return this;
    }

    @Override
    public AlleleButterflySpecies setFlightDistance(float flightDistance) {
        this.flightDistance = flightDistance;
        return this;
    }

    @Override
    public AlleleButterflySpecies setNocturnal() {
        this.isActualNocturnal = true;
        return this;
    }

    public AlleleButterflySpecies addSpawnBiomes(EnumSet<BiomeDictionary.Type> biomeTags) {
        this.spawnBiomes.addAll(biomeTags);
        return this;
    }

    public AlleleButterflySpecies addSpawnBiome(BiomeDictionary.Type biomeTag) {
        this.spawnBiomes.add(biomeTag);
        return this;
    }

    @Override
    public String getEntityTexture() {
        return this.getModID() + ":" + "textures/entity" + "/" + this.texture + ".png";
    }

    @Override
    public String getItemTexture() {
        return this.getModID() + ":items/" + this.texture;
    }

    @Override
    public EnumSet<BiomeDictionary.Type> getSpawnBiomes() {
        return this.spawnBiomes;
    }

    @Override
    public boolean strictSpawnMatch() {
        return false;
    }

    @Override
    public int getComplexity() {
        return (int)((double)(1.35f / this.rarity) * 1.5);
    }

    @Override
    public float getResearchSuitability(ItemStack itemstack) {
        if (itemstack == null) {
            return 0.0f;
        }
        if (itemstack.func_77973_b() == Items.field_151069_bo) {
            return 0.9f;
        }
        for (ItemStack stack : this.butterflyLoot.keySet()) {
            if (!stack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        for (ItemStack stack : this.caterpillarLoot.keySet()) {
            if (!stack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        return super.getResearchSuitability(itemstack);
    }

    @Override
    public ItemStack[] getResearchBounty(World world, GameProfile researcher, IIndividual individual, int bountyLevel) {
        return new ItemStack[]{this.getRoot().getMemberStack(individual.copy(), EnumFlutterType.SERUM)};
    }

    @Override
    public boolean isSecret() {
        return this.rarity < 0.8f;
    }

    @Override
    public float getRarity() {
        return this.rarity;
    }

    @Override
    public float getFlightDistance() {
        return this.flightDistance;
    }

    @Override
    public boolean isNocturnal() {
        return this.isActualNocturnal;
    }

    @Override
    public Map<ItemStack, Float> getButterflyLoot() {
        return this.butterflyLoot;
    }

    @Override
    public Map<ItemStack, Float> getCaterpillarLoot() {
        return this.caterpillarLoot;
    }

    @Override
    public int getSpriteColour(int renderPass) {
        if (renderPass > 0) {
            return this.serumColour.getRGB() & 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprites() {
        String spriteName = this.getItemTexture();
        TextureMap textureMap = Minecraft.func_71410_x().func_147117_R();
        textureMap.setTextureEntry(spriteName, (TextureAtlasSprite)new TextureAtlasButterfly(spriteName));
    }

    @Override
    public String getModID() {
        return this.modID;
    }
}

