/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.network.IStreamable;
import forestry.core.utils.ItemStackUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.util.Collection;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class DataInputStreamForestry
extends DataInputStream {
    public DataInputStreamForestry(InputStream in) {
        super(in);
    }

    public ItemStack readItemStack() throws IOException {
        ItemStack itemstack = null;
        String itemName = this.readUTF();
        if (!itemName.isEmpty()) {
            Item item = ItemStackUtil.getItemFromRegistry(itemName);
            byte stackSize = this.readByte();
            int meta = this.readVarInt();
            itemstack = new ItemStack(item, (int)stackSize, meta);
            if (item.func_77645_m() || item.func_77651_p()) {
                itemstack.func_77982_d(this.readNBTTagCompound());
            }
        }
        return itemstack;
    }

    public ItemStack[] readItemStacks() throws IOException {
        int stackCount = this.readVarInt();
        ItemStack[] itemStacks = new ItemStack[stackCount];
        for (int i = 0; i < stackCount; ++i) {
            itemStacks[i] = this.readItemStack();
        }
        return itemStacks;
    }

    public void readItemStacks(Collection<ItemStack> itemStacks) throws IOException {
        itemStacks.clear();
        int stackCount = this.readVarInt();
        for (int i = 0; i < stackCount; ++i) {
            itemStacks.add(this.readItemStack());
        }
    }

    public void readInventory(IInventory inventory) throws IOException {
        int size = this.readVarInt();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.readItemStack();
            inventory.func_70299_a(i, stack);
        }
    }

    public <T extends IStreamable> T readStreamable(Class<T> streamableClass) throws IOException {
        if (this.readBoolean()) {
            try {
                IStreamable streamable = (IStreamable)streamableClass.newInstance();
                streamable.readData(this);
                return (T)streamable;
            }
            catch (IOException | IllegalAccessException | InstantiationException e) {
                throw new InvalidObjectException("Failed to read Streamable for class " + streamableClass + " with error " + e);
            }
        }
        return null;
    }

    public <T extends IStreamable> void readStreamables(List<T> outputList, Class<T> streamableClass) throws IOException {
        outputList.clear();
        int length = this.readVarInt();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                T streamable = this.readStreamable(streamableClass);
                outputList.add(streamable);
            }
        }
    }

    public int readVarInt() throws IOException {
        byte b0;
        int varInt = 0;
        int size = 0;
        do {
            b0 = this.readByte();
            varInt |= (b0 & 0x7F) << size++ * 7;
            if (size <= 5) continue;
            throw new InvalidObjectException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return varInt;
    }

    public <T extends Enum<T>> T readEnum(T[] enumValues) throws IOException {
        int ordinal = enumValues.length <= 256 ? this.readByte() : this.readVarInt();
        return enumValues[ordinal];
    }

    public NBTTagCompound readNBTTagCompound() throws IOException {
        int length = this.readVarInt();
        if (length < 0) {
            return null;
        }
        return CompressedStreamTools.func_152456_a((DataInput)this, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
    }

    public FluidStack readFluidStack() throws IOException {
        int amount = this.readVarInt();
        if (amount > 0) {
            String fluidName = this.readUTF();
            Fluid fluid = FluidRegistry.getFluid((String)fluidName);
            if (fluid == null) {
                return null;
            }
            return new FluidStack(fluid, amount);
        }
        return null;
    }
}

