/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.blocks.BlockBase;
import forestry.core.proxy.Proxies;
import forestry.core.render.EnumTankLevel;
import forestry.core.render.ForestryResource;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.IRenderableTile;
import forestry.core.tiles.TileBase;
import java.awt.Color;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class RenderMachine
extends TileEntitySpecialRenderer<TileBase> {
    private final ModelRenderer basefront;
    private final ModelRenderer baseback;
    private final ModelRenderer resourceTank;
    private final ModelRenderer productTank;
    private ResourceLocation textureBase;
    private ResourceLocation textureResourceTank;
    private ResourceLocation textureProductTank;
    private final EnumMap<EnumTankLevel, ResourceLocation> texturesTankLevels = new EnumMap(EnumTankLevel.class);

    private RenderMachine() {
        RenderModelBase model = new RenderModelBase();
        this.basefront = new ModelRenderer((ModelBase)model, 0, 0);
        this.basefront.func_78789_a(-8.0f, -8.0f, -8.0f, 16, 4, 16);
        this.basefront.field_78800_c = 8.0f;
        this.basefront.field_78797_d = 8.0f;
        this.basefront.field_78798_e = 8.0f;
        this.baseback = new ModelRenderer((ModelBase)model, 0, 0);
        this.baseback.func_78789_a(-8.0f, 4.0f, -8.0f, 16, 4, 16);
        this.baseback.field_78800_c = 8.0f;
        this.baseback.field_78797_d = 8.0f;
        this.baseback.field_78798_e = 8.0f;
        this.resourceTank = new ModelRenderer((ModelBase)model, 0, 0);
        this.resourceTank.func_78789_a(-6.0f, -8.0f, -6.0f, 12, 16, 6);
        this.resourceTank.field_78800_c = 8.0f;
        this.resourceTank.field_78797_d = 8.0f;
        this.resourceTank.field_78798_e = 8.0f;
        this.productTank = new ModelRenderer((ModelBase)model, 0, 0);
        this.productTank.func_78789_a(-6.0f, -8.0f, 0.0f, 12, 16, 6);
        this.productTank.field_78800_c = 8.0f;
        this.productTank.field_78797_d = 8.0f;
        this.productTank.field_78798_e = 8.0f;
    }

    public RenderMachine(String baseTexture) {
        this();
        this.textureBase = new ForestryResource(baseTexture + "base.png");
        this.textureProductTank = new ForestryResource(baseTexture + "tank_product_empty.png");
        this.textureResourceTank = new ForestryResource(baseTexture + "tank_resource_empty.png");
        for (EnumTankLevel tankLevel : EnumTankLevel.values()) {
            if (tankLevel == EnumTankLevel.EMPTY) continue;
            String tankLevelString = tankLevel.toString().toLowerCase(Locale.ENGLISH);
            this.texturesTankLevels.put(tankLevel, new ForestryResource("textures/blocks/machine_tank_" + tankLevelString + ".png"));
        }
    }

    public void renderTileEntityAt(TileBase tile, double x, double y, double z, float partialTicks, int destroyStage) {
        if (tile != null) {
            IRenderableTile generator = (IRenderableTile)((Object)tile);
            IBlockState blockState = tile.getWorldObj().func_180495_p(tile.func_174877_v());
            if (blockState != null && blockState.func_177230_c() instanceof BlockBase) {
                EnumFacing facing = (EnumFacing)blockState.func_177229_b(BlockBase.FACING);
                this.render(generator.getResourceTankInfo(), generator.getProductTankInfo(), facing, x, y, z, destroyStage);
                return;
            }
        }
        this.render(TankRenderInfo.EMPTY, TankRenderInfo.EMPTY, EnumFacing.SOUTH, x, y, z, -1);
    }

    private void render(TankRenderInfo resourceTankInfo, TankRenderInfo productTankInfo, EnumFacing orientation, double x, double y, double z, int destroyStage) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        if (orientation == null) {
            orientation = EnumFacing.WEST;
        }
        switch (orientation) {
            case EAST: {
                angle[1] = (float)Math.PI;
                angle[2] = -1.5707964f;
                break;
            }
            case WEST: {
                angle[2] = 1.5707964f;
                break;
            }
            case UP: {
                break;
            }
            case DOWN: {
                angle[2] = (float)Math.PI;
                break;
            }
            case SOUTH: {
                angle[0] = 1.5707964f;
                angle[2] = 1.5707964f;
                break;
            }
            default: {
                angle[0] = -1.5707964f;
                angle[2] = 1.5707964f;
            }
        }
        this.basefront.field_78795_f = angle[0];
        this.basefront.field_78796_g = angle[1];
        this.basefront.field_78808_h = angle[2];
        this.baseback.field_78795_f = angle[0];
        this.baseback.field_78796_g = angle[1];
        this.baseback.field_78808_h = angle[2];
        this.resourceTank.field_78795_f = angle[0];
        this.resourceTank.field_78796_g = angle[1];
        this.resourceTank.field_78808_h = angle[2];
        this.productTank.field_78795_f = angle[0];
        this.productTank.field_78796_g = angle[1];
        this.productTank.field_78808_h = angle[2];
        float factor = 0.0625f;
        Proxies.render.bindTexture(this.textureBase);
        this.basefront.func_78785_a(factor);
        this.baseback.func_78785_a(factor);
        this.renderTank(this.resourceTank, this.textureResourceTank, resourceTankInfo, factor);
        this.renderTank(this.productTank, this.textureProductTank, productTankInfo, factor);
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderTank(ModelRenderer tankModel, ResourceLocation textureBase, TankRenderInfo renderInfo, float factor) {
        Proxies.render.bindTexture(textureBase);
        tankModel.func_78785_a(factor);
        ResourceLocation textureResourceTankLevel = this.texturesTankLevels.get((Object)renderInfo.getLevel());
        if (textureResourceTankLevel == null) {
            return;
        }
        Color primaryTankColor = renderInfo.getFluidColor();
        float[] colors = new float[3];
        primaryTankColor.getRGBColorComponents(colors);
        GlStateManager.func_179131_c((float)colors[0], (float)colors[1], (float)colors[2], (float)1.0f);
        Proxies.render.bindTexture(textureResourceTankLevel);
        tankModel.func_78785_a(factor);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static class RenderModelBase
    extends ModelBase {
        private RenderModelBase() {
        }
    }
}

