/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gui;

import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import forestry.farming.gui.IFarmLedgerDelegate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;

public class FarmLedger
extends Ledger {
    private final IFarmLedgerDelegate delegate;

    public FarmLedger(LedgerManager ledgerManager, IFarmLedgerDelegate delegate) {
        super(ledgerManager, "farm");
        this.delegate = delegate;
        int titleHeight = StringUtil.getLineHeight(this.maxTextWidth, this.getTooltip());
        this.maxHeight = titleHeight + 110;
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        y += 4;
        int xIcon = x + 3;
        int xBody = x + 10;
        int xHeader = x + 22;
        Minecraft minecraft = Proxies.common.getClientInstance();
        TextureMap textureMapBlocks = minecraft.func_147117_R();
        TextureAtlasSprite textureAtlasSprite = textureMapBlocks.func_110572_b("minecraft:items/bucket_water");
        this.drawSprite(textureAtlasSprite, xIcon, y);
        y += 4;
        if (!this.isFullyOpened()) {
            return;
        }
        y += this.drawHeader(Translator.translateToLocal("for.gui.hydration"), xHeader, y);
        y += 4;
        y += this.drawSubheader(Translator.translateToLocal("for.gui.hydr.heat") + ':', xBody, y);
        y += 3;
        y += this.drawText(StringUtil.floatAsPercent(this.delegate.getHydrationTempModifier()), xBody, y);
        y += 3;
        y += this.drawSubheader(Translator.translateToLocal("for.gui.hydr.humid") + ':', xBody, y);
        y += 3;
        y += this.drawText(StringUtil.floatAsPercent(this.delegate.getHydrationHumidModifier()), xBody, y);
        y += 3;
        y += this.drawSubheader(Translator.translateToLocal("for.gui.hydr.rainfall") + ':', xBody, y);
        y += 3;
        y += this.drawText(StringUtil.floatAsPercent(this.delegate.getHydrationRainfallModifier()) + " (" + this.delegate.getDrought() + " d)", xBody, y);
        y += 3;
        y += this.drawSubheader(Translator.translateToLocal("for.gui.hydr.overall") + ':', xBody, y);
        this.drawText(StringUtil.floatAsPercent(this.delegate.getHydrationModifier()), xBody, y += 3);
    }

    @Override
    public String getTooltip() {
        float hydrationModifier = this.delegate.getHydrationModifier();
        return StringUtil.floatAsPercent(hydrationModifier) + ' ' + Translator.translateToLocal("for.gui.hydration");
    }
}

