/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.circuits;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import forestry.core.circuits.Circuit;

public class CircuitFarmLogic
extends Circuit {
    private final IFarmLogic logic;
    private boolean isManual = false;

    public CircuitFarmLogic(String uid, IFarmLogic logic) {
        super(uid, false);
        this.logic = logic;
        this.setLimit(4);
    }

    public CircuitFarmLogic setManual() {
        this.isManual = true;
        return this;
    }

    @Override
    public boolean isCircuitable(Object tile) {
        return tile instanceof IFarmHousing;
    }

    private IFarmHousing getCircuitable(Object tile) {
        if (!this.isCircuitable(tile)) {
            return null;
        }
        return (IFarmHousing)tile;
    }

    @Override
    public void onInsertion(int slot, Object tile) {
        IFarmHousing housing = this.getCircuitable(tile);
        if (housing == null) {
            return;
        }
        this.logic.setManual(this.isManual);
        housing.setFarmLogic(FarmDirection.values()[slot], this.logic);
    }

    @Override
    public void onLoad(int slot, Object tile) {
        this.onInsertion(slot, tile);
    }

    @Override
    public void onRemoval(int slot, Object tile) {
        IFarmHousing farmHousing = this.getCircuitable(tile);
        if (farmHousing == null) {
            return;
        }
        farmHousing.resetFarmLogic(FarmDirection.values()[slot]);
    }

    @Override
    public void onTick(int slot, Object tile) {
    }
}

