/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import forestry.core.gui.slots.SlotFilteredInventory;
import forestry.core.gui.slots.SlotForestry;
import forestry.core.gui.slots.SlotLocked;
import forestry.core.network.IForestryPacketClient;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Log;
import forestry.core.utils.SlotUtil;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

@ChestContainer(showButtons=false)
public abstract class ContainerForestry
extends Container {
    protected final void addPlayerInventory(InventoryPlayer playerInventory, int xInv, int yInv) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.func_75146_a(new Slot((IInventory)playerInventory, column + row * 9 + 9, xInv + column * 18, yInv + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.addHotbarSlot(playerInventory, column, xInv + column * 18, yInv + 58);
        }
    }

    protected void addHotbarSlot(InventoryPlayer playerInventory, int slot, int x, int y) {
        this.func_75146_a(new Slot((IInventory)playerInventory, slot, x, y));
    }

    public Slot func_75146_a(Slot p_75146_1_) {
        return super.func_75146_a(p_75146_1_);
    }

    public ItemStack func_184996_a(int slotId, int dragType_or_button, ClickType clickTypeIn, EntityPlayer player) {
        SlotForestry slotForestry;
        Slot slot;
        int hotbarSlotIndex;
        Slot hotbarSlot;
        if (!this.canAccess(player)) {
            return null;
        }
        if (clickTypeIn == ClickType.SWAP && dragType_or_button >= 0 && dragType_or_button < 9 && (hotbarSlot = this.func_75139_a(hotbarSlotIndex = 27 + dragType_or_button)) instanceof SlotLocked) {
            return null;
        }
        Slot slot2 = slot = slotId < 0 ? null : this.func_75139_a(slotId);
        if (slot instanceof SlotForestry && (slotForestry = (SlotForestry)slot).isPhantom()) {
            return SlotUtil.slotClickPhantom(slotForestry, dragType_or_button, clickTypeIn, player);
        }
        return super.func_184996_a(slotId, dragType_or_button, clickTypeIn, player);
    }

    public final ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        if (!this.canAccess(player)) {
            return null;
        }
        return SlotUtil.transferStackInSlot(this.field_75151_b, player, slotIndex);
    }

    protected abstract boolean canAccess(EntityPlayer var1);

    protected final void sendPacketToListeners(IForestryPacketClient packet) {
        for (IContainerListener listener : this.field_75149_d) {
            if (listener instanceof EntityPlayer) {
                Proxies.net.sendToPlayer(packet, (EntityPlayer)listener);
                continue;
            }
            Log.error("Unknown listener type: {}", listener);
        }
    }

    @ContainerSectionCallback
    public Map<ContainerSection, List<Slot>> getContainerSections() {
        ArrayListMultimap map = ArrayListMultimap.create();
        for (Object object : this.field_75151_b) {
            if (!(object instanceof Slot)) continue;
            Slot slot = (Slot)object;
            if (slot.field_75224_c instanceof InventoryPlayer) {
                map.put((Object)ContainerSection.INVENTORY, (Object)slot);
                if (slot.field_75222_d < 9) {
                    map.put((Object)ContainerSection.INVENTORY_HOTBAR, (Object)slot);
                    continue;
                }
                if (slot.field_75222_d < 36) {
                    map.put((Object)ContainerSection.INVENTORY_NOT_HOTBAR, (Object)slot);
                    continue;
                }
                map.put((Object)ContainerSection.ARMOR, (Object)slot);
                continue;
            }
            if (slot instanceof SlotForestry && !(slot instanceof SlotFilteredInventory)) continue;
            map.put((Object)ContainerSection.CHEST, (Object)slot);
        }
        return Multimaps.asMap((ListMultimap)map);
    }
}

