/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.IHiveTile;
import forestry.api.apiculture.hives.IHiveRegistry;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.genetics.IAllele;
import forestry.apiculture.BeekeepingLogic;
import forestry.apiculture.blocks.BlockBeeHives;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.genetics.alleles.AlleleEffect;
import forestry.apiculture.network.packets.PacketActiveUpdate;
import forestry.apiculture.tiles.HiveBeeHousingInventory;
import forestry.core.config.Config;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IActivatable;
import forestry.core.utils.DamageSourceForestry;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class TileHive
extends TileEntity
implements ITickable,
IHiveTile,
IActivatable,
IBeeHousing {
    private static final DamageSource damageSourceBeeHive = new DamageSourceForestry("bee.hive");
    @Nonnull
    private final InventoryAdapter contained = new InventoryAdapter(2, "Contained");
    @Nonnull
    private final HiveBeeHousingInventory inventory = new HiveBeeHousingInventory(this);
    @Nonnull
    private final BeekeepingLogic beeLogic = new BeekeepingLogic(this);
    @Nonnull
    private final IErrorLogic errorLogic = ForestryAPI.errorStateRegistry.createErrorLogic();
    private IBee containedBee = null;
    private boolean active = false;
    private boolean angry = false;
    private int calmTime;
    private boolean updatedLight;

    public void func_73660_a() {
        if (Config.generateBeehivesDebug) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            if (!this.updatedLight && this.field_145850_b.func_72820_D() % 100L == 0L) {
                this.updatedLight = this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
            }
            if (this.active && this.field_145850_b.field_73012_v.nextInt(4) == 0 && this.beeLogic.canDoBeeFX()) {
                this.beeLogic.doBeeFX();
            }
        } else {
            boolean canWork = this.beeLogic.canWork();
            if (this.field_145850_b.field_73012_v.nextInt(this.angry ? 10 : 200) == 0) {
                if (this.calmTime == 0) {
                    if (canWork) {
                        AxisAlignedBB boundingBox = AlleleEffect.getBounding(this.getContainedBee().getGenome(), this);
                        List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, boundingBox);
                        if (!entities.isEmpty()) {
                            Collections.shuffle(entities);
                            EntityLivingBase entity = (EntityLivingBase)entities.get(0);
                            TileHive.attack(entity, 2);
                        }
                        this.beeLogic.doWork();
                    }
                } else {
                    --this.calmTime;
                }
            }
            this.setActive(this.calmTime == 0);
        }
    }

    public IBee getContainedBee() {
        if (this.containedBee == null) {
            IBee bee;
            IBeeGenome beeGenome = null;
            ItemStack containedBee = this.contained.func_70301_a(0);
            if (containedBee != null && (bee = BeeManager.beeRoot.getMember(containedBee)) != null) {
                beeGenome = bee.getGenome();
            }
            if (beeGenome == null) {
                beeGenome = this.getGenomeFromBlock();
            }
            if (beeGenome == null) {
                beeGenome = BeeDefinition.FOREST.getGenome();
            }
            this.containedBee = BeeManager.beeRoot.getBee(beeGenome);
        }
        return this.containedBee;
    }

    private IBeeGenome getGenomeFromBlock() {
        String speciesUid;
        IAllele[] template;
        IHiveRegistry.HiveType hiveType;
        Block block;
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (blockState != null && (block = blockState.func_177230_c()) instanceof BlockBeeHives && (hiveType = BlockBeeHives.getHiveType(blockState)) != null && (template = BeeManager.beeRoot.getTemplate(speciesUid = hiveType.getSpeciesUid())) != null) {
            return BeeManager.beeRoot.templateAsGenome(template);
        }
        return null;
    }

    public void setContained(@Nonnull List<ItemStack> bees) {
        for (ItemStack itemstack : bees) {
            InventoryUtil.addStack((IInventory)this.contained, itemstack, true);
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.contained.readFromNBT(nbttagcompound);
        this.beeLogic.readFromNBT(nbttagcompound);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.contained.writeToNBT(nbttagcompound);
        this.beeLogic.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void calmBees() {
        this.calmTime = 5;
        this.angry = false;
        this.setActive(false);
    }

    @Override
    public boolean isAngry() {
        return this.angry;
    }

    @Override
    public void onAttack(World world, BlockPos pos, EntityPlayer player) {
        if (this.calmTime == 0) {
            this.angry = true;
        }
    }

    @Override
    public void onBroken(World world, BlockPos pos, EntityPlayer player, boolean canHarvest) {
        if (this.calmTime == 0) {
            TileHive.attack((EntityLivingBase)player, 10);
        }
        if (canHarvest) {
            for (ItemStack beeStack : InventoryUtil.getStacks((IInventory)this.contained)) {
                if (beeStack == null) continue;
                ItemStackUtil.dropItemStackAsEntity(beeStack, this.field_145850_b, pos);
            }
        }
    }

    private static void attack(EntityLivingBase entity, int maxDamage) {
        int count;
        double attackAmount = entity.field_70170_p.field_73012_v.nextDouble() / 2.0 + 0.5;
        int damage = (int)(attackAmount * (double)maxDamage);
        if (damage > 0 && (damage = (int)((float)damage - (float)damage / 4.0f * (float)(count = BeeManager.armorApiaristHelper.wearsItems(entity, TileHive.damageSourceBeeHive.field_76373_n, true)))) > 0) {
            entity.func_70097_a(damageSourceBeeHive, (float)damage);
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (!this.field_145850_b.field_72995_K) {
            Proxies.net.sendNetworkPacket(new PacketActiveUpdate(this), this.field_145850_b);
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_74757_a("active", this.calmTime == 0);
        this.beeLogic.writeToNBT(nbt);
        return nbt;
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.setActive(tag.func_74767_n("active"));
        this.beeLogic.readFromNBT(tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound nbt = pkt.func_148857_g();
        this.handleUpdateTag(nbt);
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return Collections.emptyList();
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.emptyList();
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beeLogic;
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome(this.getBiome(), this.func_145831_w(), this.func_174877_v());
    }

    @Override
    public EnumHumidity getHumidity() {
        float humidity = ForestryAPI.climateManager.getHumidity(this.func_145831_w(), this.func_174877_v());
        return EnumHumidity.getFromValue(humidity);
    }

    @Override
    public int getBlockLightValue() {
        return this.func_145831_w().func_72935_r() ? 15 : 0;
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return true;
    }

    @Override
    public World getWorldObj() {
        return this.field_145850_b;
    }

    @Override
    public Biome getBiome() {
        return this.func_145831_w().func_180494_b(this.func_174877_v());
    }

    @Override
    public GameProfile getOwner() {
        return null;
    }

    @Override
    public Vec3d getBeeFXCoordinates() {
        BlockPos pos = this.func_174877_v();
        return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() + 0.5);
    }

    @Override
    @Nonnull
    public IErrorLogic getErrorLogic() {
        return this.errorLogic;
    }

    @Override
    public BlockPos getCoordinates() {
        return this.func_174877_v();
    }
}

