/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.logics;

import forestry.api.greenhouse.DefaultGreenhouseLogic;
import forestry.api.greenhouse.IGreenhouseClimaLogic;
import forestry.api.multiblock.IGreenhouseController;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.greenhouse.tiles.TileGreenhouseDoor;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;

public class GreenhouseLogicGreenhouseDoor
extends DefaultGreenhouseLogic
implements IGreenhouseClimaLogic {
    private int workTimer;

    public GreenhouseLogicGreenhouseDoor(IGreenhouseController controller) {
        super(controller, "GreenhouseDoor");
    }

    @Override
    public void work() {
        if (this.controller == null || !this.controller.isAssembled()) {
            return;
        }
        if (this.workTimer++ > 20) {
            int openDoors = 0;
            for (IMultiblockComponent component : this.controller.getComponents()) {
                IBlockState state;
                if (!(component instanceof TileGreenhouseDoor) || !((Boolean)(state = ((TileGreenhouseDoor)component).func_145831_w().func_180495_p(component.getCoordinates())).func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) continue;
                ++openDoors;
            }
            this.controller.addTemperatureChange(-1.0E-4f * (float)openDoors, 0.05f, 2.5f);
            this.controller.addHumidityChange(-1.0E-4f * (float)openDoors, 0.05f, 2.5f);
            this.workTimer = 0;
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("workTimer", this.workTimer);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.workTimer = nbt.func_74762_e("workTimer");
    }
}

