/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.tiles;

import forestry.api.core.IErrorLogic;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FuelManager;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TileEngine;
import forestry.energy.gui.ContainerEngineBiogas;
import forestry.energy.gui.GuiEngineBiogas;
import forestry.energy.inventory.InventoryEngineBiogas;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEngineBiogas
extends TileEngine
implements ISidedInventory,
ILiquidTankTile,
IFluidHandler {
    private final FilteredTank fuelTank;
    private final FilteredTank heatingTank;
    private final StandardTank burnTank;
    private final TankManager tankManager;
    private boolean shutdown;

    public TileEngineBiogas() {
        super("engine.bronze", 10000, 300000);
        this.setInternalInventory(new InventoryEngineBiogas(this));
        this.fuelTank = new FilteredTank(10000, FuelManager.bronzeEngineFuel.keySet());
        this.fuelTank.tankMode = StandardTank.TankMode.DEFAULT;
        this.heatingTank = new FilteredTank(10000, FluidRegistry.LAVA);
        this.heatingTank.tankMode = StandardTank.TankMode.INPUT;
        this.burnTank = new StandardTank(1000);
        this.burnTank.tankMode = StandardTank.TankMode.INTERNAL;
        this.tankManager = new TankManager(this, this.fuelTank, this.heatingTank, this.burnTank);
    }

    @Override
    @Nonnull
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public Fluid getBurnTankFluidType() {
        return this.burnTank.getFluidType();
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (!this.updateOnInterval(20)) {
            return;
        }
        FluidHelper.drainContainers(this.tankManager, (IInventory)this, 0);
        IErrorLogic errorLogic = this.getErrorLogic();
        boolean hasHeat = this.getHeatLevel() > 0.2 || this.heatingTank.getFluidAmount() > 0;
        errorLogic.setCondition(!hasHeat, EnumErrorCode.NO_HEAT);
        boolean hasFuel = this.burnTank.getFluidAmount() > 0 || this.fuelTank.getFluidAmount() > 0;
        errorLogic.setCondition(!hasFuel, EnumErrorCode.NO_FUEL);
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (this.isRedstoneActivated() && (this.fuelTank.getFluidAmount() >= 1000 || this.burnTank.getFluidAmount() > 0)) {
            double heatStage = this.getHeatLevel();
            if (heatStage > 0.25 && this.shutdown) {
                this.shutdown(false);
            } else if (this.shutdown && this.heatingTank.getFluidAmount() > 0 && Fluids.LAVA.is(this.heatingTank.getFluid())) {
                this.addHeat(20);
                this.heatingTank.drain(1, true);
            }
            if (heatStage > 0.2) {
                if (this.burnTank.getFluidAmount() > 0) {
                    FluidStack drained = this.burnTank.drain(1, true);
                    this.currentOutput = TileEngineBiogas.determineFuelValue(drained.getFluid());
                    this.energyManager.generateEnergy(this.currentOutput);
                } else {
                    int burnTime;
                    FluidStack fuel = this.fuelTank.drain(1000, true);
                    fuel.amount = burnTime = TileEngineBiogas.determineBurnTime(fuel.getFluid());
                    this.burnTank.setCapacity(burnTime);
                    this.burnTank.setFluid(fuel);
                }
            } else {
                this.shutdown(true);
            }
        }
    }

    private void shutdown(boolean val) {
        this.shutdown = val;
    }

    @Override
    public int dissipateHeat() {
        FluidStack fuelFluidStack;
        EngineBronzeFuel fuel;
        double heatStage;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 1;
        if (!this.isBurning()) {
            ++loss;
        }
        if ((heatStage = this.getHeatLevel()) > 0.55) {
            ++loss;
        }
        if (this.fuelTank.getFluidAmount() > 0 && (fuel = FuelManager.bronzeEngineFuel.get((fuelFluidStack = this.fuelTank.getFluid()).getFluid())) != null) {
            loss *= fuel.dissipationMultiplier;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int generate = 0;
        if (this.isRedstoneActivated() && this.burnTank.getFluidAmount() > 0) {
            double heatStage = this.getHeatLevel();
            if (heatStage >= 0.75) {
                generate += 3;
            } else if (heatStage > 0.24) {
                generate += 2;
            } else if (heatStage > 0.2) {
                ++generate;
            }
        }
        this.heat += generate;
        return generate;
    }

    private static int determineFuelValue(Fluid fluid) {
        if (FuelManager.bronzeEngineFuel.containsKey(fluid)) {
            return FuelManager.bronzeEngineFuel.get((Object)fluid).powerPerCycle;
        }
        return 0;
    }

    private static int determineBurnTime(Fluid fluid) {
        if (FuelManager.bronzeEngineFuel.containsKey(fluid)) {
            return FuelManager.bronzeEngineFuel.get((Object)fluid).burnDuration;
        }
        return 0;
    }

    @Override
    protected boolean isBurning() {
        return this.mayBurn() && this.burnTank.getFluidAmount() > 0;
    }

    @Override
    public int getBurnTimeRemainingScaled(int i) {
        if (this.burnTank.getCapacity() == 0) {
            return 0;
        }
        return this.burnTank.getFluidAmount() * i / this.burnTank.getCapacity();
    }

    public int getOperatingTemperatureScaled(int i) {
        return (int)Math.round((double)(this.heat * i) / ((double)this.maxHeat * 0.2));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("shutdown")) {
            this.shutdown = nbt.func_74767_n("shutdown");
        }
        this.tankManager.readFromNBT(nbt);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74757_a("shutdown", this.shutdown);
        this.tankManager.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeBoolean(this.shutdown);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.shutdown = data.readBoolean();
        this.tankManager.readData(data);
    }

    @Override
    public void getGUINetworkData(int id, int data) {
        switch (id) {
            case 0: {
                this.currentOutput = data;
                break;
            }
            case 1: {
                this.energyManager.fromGuiInt(data);
                break;
            }
            case 2: {
                this.heat = data;
                break;
            }
            case 3: {
                this.burnTank.setCapacity(data);
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container containerEngine, IContainerListener iCrafting) {
        iCrafting.func_71112_a(containerEngine, 0, this.currentOutput);
        iCrafting.func_71112_a(containerEngine, 1, this.energyManager.toGuiInt());
        iCrafting.func_71112_a(containerEngine, 2, this.heat);
        iCrafting.func_71112_a(containerEngine, 3, this.burnTank.getCapacity());
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return this.tankManager.getTankInfo(from);
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiEngineBiogas(player.field_71071_by, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerEngineBiogas(player.field_71071_by, this);
    }
}

