/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.multiblock;

import forestry.api.core.EnumCamouflageType;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ICamouflagedTile;
import forestry.api.greenhouse.EnumGreenhouseEventType;
import forestry.api.greenhouse.GreenhouseEvents;
import forestry.api.greenhouse.GreenhouseManager;
import forestry.api.greenhouse.IGreenhouseLogic;
import forestry.api.greenhouse.IGreenhouseState;
import forestry.api.greenhouse.IInternalBlock;
import forestry.api.greenhouse.IInternalBlockFace;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.api.multiblock.IGreenhouseController;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.access.EnumAccess;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.multiblock.RectangularMultiblockControllerBase;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.utils.CamouflageUtil;
import forestry.core.utils.Log;
import forestry.core.utils.Translator;
import forestry.energy.EnergyManager;
import forestry.greenhouse.GreenhouseState;
import forestry.greenhouse.blocks.BlockGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.inventory.InventoryGreenhouse;
import forestry.greenhouse.multiblock.GreenhouseMultiblockSizeLimits;
import forestry.greenhouse.multiblock.IGreenhouseControllerInternal;
import forestry.greenhouse.multiblock.InternalBlock;
import forestry.greenhouse.network.packets.PacketCamouflageUpdate;
import forestry.greenhouse.tiles.TileGreenhouseSprinkler;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GreenhouseController
extends RectangularMultiblockControllerBase
implements IGreenhouseControllerInternal,
ILiquidTankTile {
    private final List<IInternalBlock> internalBlocks = new ArrayList<IInternalBlock>();
    private final Set<IGreenhouseComponent.Listener> listenerComponents = new HashSet<IGreenhouseComponent.Listener>();
    private final Set<IGreenhouseComponent.Climatiser> climatiserComponents = new HashSet<IGreenhouseComponent.Climatiser>();
    private final Set<IGreenhouseComponent.Active> activeComponents = new HashSet<IGreenhouseComponent.Active>();
    private final List<IGreenhouseLogic> logics = new ArrayList<IGreenhouseLogic>();
    private float tempChange = 0.0f;
    private float humidChange = 0.0f;
    private Biome cachedBiome;
    private final TankManager tankManager;
    private final StandardTank resourceTank = new FilteredTank(10000, FluidRegistry.WATER);
    private final EnergyManager energyManager;
    private final InventoryGreenhouse inventory;
    private ItemStack camouflagePlainBlock;
    private ItemStack camouflageGlassBlock;
    private ItemStack camouflageDoorBlock;

    public GreenhouseController(World world) {
        super(world, GreenhouseMultiblockSizeLimits.instance);
        this.tankManager = new TankManager(this, this.resourceTank);
        this.energyManager = new EnergyManager(2000, 100000);
        this.inventory = new InventoryGreenhouse(this);
        this.camouflagePlainBlock = this.getDefaultCamouflageBlock(EnumCamouflageType.DEFAULT);
        this.camouflageGlassBlock = this.getDefaultCamouflageBlock(EnumCamouflageType.GLASS);
        this.camouflageDoorBlock = this.getDefaultCamouflageBlock(EnumCamouflageType.DOOR);
    }

    @Override
    public EnumTemperature getTemperature() {
        BlockPos coords = this.getReferenceCoord();
        return EnumTemperature.getFromValue(this.getExactTemperature());
    }

    private Biome getBiome() {
        if (this.cachedBiome == null) {
            BlockPos coords = this.getReferenceCoord();
            this.cachedBiome = this.worldObj.func_180494_b(coords);
        }
        return this.cachedBiome;
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getExactTemperature() {
        BlockPos coords = this.getReferenceCoord();
        return this.getBiome().func_180626_a(coords) + this.tempChange;
    }

    @Override
    public float getExactHumidity() {
        return this.getBiome().func_76727_i() + this.humidChange;
    }

    @Override
    public void addTemperatureChange(float change, float boundaryDown, float boundaryUp) {
        BlockPos coordinates = this.getCoordinates();
        float temperature = this.getBiome().func_180626_a(coordinates);
        this.tempChange += change;
        this.tempChange = Math.max(boundaryDown - temperature, this.tempChange);
        this.tempChange = Math.min(boundaryUp - temperature, this.tempChange);
    }

    @Override
    public void addHumidityChange(float change, float boundaryDown, float boundaryUp) {
        float humidity = this.getBiome().func_76727_i();
        this.humidChange += change;
        this.humidChange = Math.max(boundaryDown - humidity, this.humidChange);
        this.humidChange = Math.min(boundaryUp - humidity, this.humidChange);
    }

    private static float equalizeChange(float change) {
        if (change == 0.0f) {
            return 0.0f;
        }
        if ((change *= 0.95f) <= 0.001f && change >= -0.001f) {
            change = 0.0f;
        }
        return change;
    }

    @Override
    public String getUnlocalizedType() {
        return "for.multiblock.greenhouse.type";
    }

    @Override
    public BlockPos getCoordinates() {
        BlockPos coord = this.getReferenceCoord();
        return new BlockPos((Vec3i)coord);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data = super.writeToNBT(data);
        data.func_74776_a("Temperature", this.tempChange);
        data.func_74776_a("Humidity", this.humidChange);
        this.tankManager.writeToNBT(data);
        this.energyManager.writeToNBT(data);
        this.inventory.writeToNBT(data);
        CamouflageUtil.writeCamouflageBlockToNBT(data, this, EnumCamouflageType.DEFAULT);
        CamouflageUtil.writeCamouflageBlockToNBT(data, this, EnumCamouflageType.GLASS);
        CamouflageUtil.writeCamouflageBlockToNBT(data, this, EnumCamouflageType.DOOR);
        for (IGreenhouseLogic logic : this.getLogics()) {
            NBTTagCompound nbtTag = new NBTTagCompound();
            logic.writeToNBT(nbtTag);
            data.func_74782_a("logic" + logic.getName(), (NBTBase)nbtTag);
        }
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.tempChange = data.func_74760_g("Temperature");
        this.humidChange = data.func_74760_g("Humidity");
        this.tankManager.readFromNBT(data);
        this.energyManager.readFromNBT(data);
        this.inventory.readFromNBT(data);
        CamouflageUtil.readCamouflageBlockFromNBT(data, this, EnumCamouflageType.DEFAULT);
        CamouflageUtil.readCamouflageBlockFromNBT(data, this, EnumCamouflageType.GLASS);
        CamouflageUtil.readCamouflageBlockFromNBT(data, this, EnumCamouflageType.DOOR);
        if (this.logics.isEmpty()) {
            this.createLogics();
        }
        for (IGreenhouseLogic logic : this.getLogics()) {
            logic.readFromNBT(data.func_74775_l("logic" + logic.getName()));
        }
    }

    @Override
    public void formatDescriptionPacket(NBTTagCompound data) {
        this.writeToNBT(data);
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
        this.readFromNBT(data);
    }

    @Override
    protected void onAttachedPartWithMultiblockData(IMultiblockComponent part, NBTTagCompound data) {
        this.readFromNBT(data);
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
        if (oldAccess == EnumAccess.SHARED || newAccess == EnumAccess.SHARED) {
            for (IMultiblockComponent part : this.connectedParts) {
                if (!(part instanceof TileEntity)) continue;
                TileEntity tile = (TileEntity)part;
                this.worldObj.func_180496_d(tile.func_174877_v(), tile.func_145838_q());
            }
            this.func_70296_d();
        }
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        data.writeVarInt(Math.round(this.tempChange * 100.0f));
        data.writeVarInt(Math.round(this.humidChange * 100.0f));
        this.tankManager.writeData(data);
        this.energyManager.writeData(data);
        this.inventory.writeData(data);
        CamouflageUtil.writeCamouflageBlockToData(data, this, EnumCamouflageType.DEFAULT);
        CamouflageUtil.writeCamouflageBlockToData(data, this, EnumCamouflageType.GLASS);
        CamouflageUtil.writeCamouflageBlockToData(data, this, EnumCamouflageType.DOOR);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.tempChange = (float)data.readVarInt() / 100.0f;
        this.humidChange = (float)data.readVarInt() / 100.0f;
        this.tankManager.readData(data);
        this.energyManager.readData(data);
        this.inventory.readData(data);
        CamouflageUtil.readCamouflageBlockFromData(data, this);
        CamouflageUtil.readCamouflageBlockFromData(data, this);
        CamouflageUtil.readCamouflageBlockFromData(data, this);
    }

    @Override
    public void setCamouflageBlock(EnumCamouflageType type, ItemStack camouflageBlock) {
        switch (type) {
            case DEFAULT: {
                this.camouflagePlainBlock = camouflageBlock;
                break;
            }
            case GLASS: {
                this.camouflageGlassBlock = camouflageBlock;
                break;
            }
            case DOOR: {
                this.camouflageDoorBlock = camouflageBlock;
                break;
            }
            default: {
                return;
            }
        }
        if (this.worldObj != null && this.worldObj.field_72995_K) {
            for (IMultiblockComponent comp : this.connectedParts) {
                ICamouflagedTile camBlock;
                if (!(comp instanceof ICamouflagedTile) || (camBlock = (ICamouflagedTile)((Object)comp)).getCamouflageType() != type) continue;
                this.worldObj.func_175704_b(camBlock.getCoordinates(), camBlock.getCoordinates());
            }
            Proxies.net.sendToServer(new PacketCamouflageUpdate(this, type, true));
        }
        MinecraftForge.EVENT_BUS.post((Event)new GreenhouseEvents.CamouflageChangeEvent(this.createState(), null, this, type));
    }

    @Override
    public ItemStack getCamouflageBlock(EnumCamouflageType type) {
        switch (type) {
            case DEFAULT: {
                return this.camouflagePlainBlock;
            }
            case GLASS: {
                return this.camouflageGlassBlock;
            }
            case DOOR: {
                return this.camouflageDoorBlock;
            }
        }
        return null;
    }

    @Override
    public ItemStack getDefaultCamouflageBlock(EnumCamouflageType type) {
        switch (type) {
            case DEFAULT: {
                return new ItemStack(Blocks.field_150336_V);
            }
            case GLASS: {
                return new ItemStack((Block)Blocks.field_150399_cn, 1, 13);
            }
            case DOOR: {
                return null;
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public IGreenhouseState createState() {
        return new GreenhouseState(this);
    }

    @Override
    public void onChange(EnumGreenhouseEventType type, Object event) {
        for (IGreenhouseLogic logic : this.logics) {
            logic.onEvent(type, event);
        }
    }

    private void createLogics() {
        this.logics.clear();
        for (Class<? extends IGreenhouseLogic> logicClass : GreenhouseManager.greenhouseLogics) {
            IGreenhouseLogic logic = this.createLogic(logicClass);
            if (logic == null) continue;
            this.logics.add(logic);
        }
    }

    private IGreenhouseLogic createLogic(Class<? extends IGreenhouseLogic> logicClass) {
        try {
            return logicClass.getConstructor(IGreenhouseController.class).newInstance(this);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Log.error("Fail to create a greenhouse logic with the class: {}", logicClass, e);
            return null;
        }
    }

    @Override
    public List<IGreenhouseLogic> getLogics() {
        return this.logics;
    }

    @Override
    @Nonnull
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public EnergyManager getEnergyManager() {
        return this.energyManager;
    }

    @Override
    @Nonnull
    public IInventoryAdapter getInternalInventory() {
        if (this.isAssembled()) {
            return this.inventory;
        }
        return FakeInventoryAdapter.instance();
    }

    @Override
    protected void onMachineAssembled() {
        super.onMachineAssembled();
        this.createLogics();
    }

    @Override
    protected void onMachineDisassembled() {
        super.onMachineDisassembled();
        this.internalBlocks.clear();
        this.logics.clear();
    }

    @Override
    protected void onBlockAdded(IMultiblockComponent newPart) {
        if (newPart instanceof IGreenhouseComponent.Listener) {
            this.listenerComponents.add((IGreenhouseComponent.Listener)newPart);
        } else if (newPart instanceof IGreenhouseComponent.Climatiser) {
            this.climatiserComponents.add((IGreenhouseComponent.Climatiser)newPart);
        } else if (newPart instanceof IGreenhouseComponent.Active) {
            this.activeComponents.add((IGreenhouseComponent.Active)newPart);
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockComponent oldPart) {
        if (oldPart instanceof IGreenhouseComponent.Listener) {
            this.listenerComponents.remove(oldPart);
        } else if (oldPart instanceof IGreenhouseComponent.Climatiser) {
            this.climatiserComponents.remove(oldPart);
        } else if (oldPart instanceof IGreenhouseComponent.Active) {
            this.activeComponents.remove(oldPart);
        }
    }

    @Override
    protected void onAssimilate(IMultiblockControllerInternal assimilated) {
    }

    @Override
    public void onAssimilated(IMultiblockControllerInternal assimilator) {
    }

    @Override
    protected boolean updateServer(int tickCount) {
        if (!this.isAssembled()) {
            boolean hasChangeClima = false;
            if (this.updateOnInterval(45)) {
                if (this.humidChange > 0.0f) {
                    this.humidChange = this.humidChange > 0.25f ? -0.25f : 0.0f;
                    hasChangeClima = true;
                }
                if (this.tempChange > 0.0f) {
                    this.tempChange = this.tempChange > 0.25f ? -0.25f : 0.0f;
                    hasChangeClima = true;
                }
            }
            return hasChangeClima;
        }
        if (this.updateOnInterval(20)) {
            this.inventory.drainCan(this.tankManager);
        }
        for (IGreenhouseLogic logic : this.logics) {
            logic.work();
        }
        for (IGreenhouseComponent.Active activeComponent : this.activeComponents) {
            activeComponent.updateServer(tickCount);
        }
        boolean canWork = true;
        for (IGreenhouseComponent.Listener listenerComponent : this.listenerComponents) {
            canWork = listenerComponent.getGreenhouseListener().canWork(this, canWork);
        }
        if (canWork) {
            for (IGreenhouseComponent.Climatiser climatiser : this.climatiserComponents) {
                climatiser.changeClimate(tickCount, this);
            }
            this.tempChange = GreenhouseController.equalizeChange(this.tempChange);
            this.humidChange = GreenhouseController.equalizeChange(this.humidChange);
        }
        return canWork;
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        int minX = this.getSizeLimits().getMinimumXSize();
        int minY = this.getSizeLimits().getMinimumYSize();
        int minZ = this.getSizeLimits().getMinimumZSize();
        BlockPos maximumCoord = this.getMaximumCoord();
        BlockPos minimumCoord = this.getMinimumCoord();
        int deltaX = maximumCoord.func_177958_n() - minimumCoord.func_177958_n() + 1;
        int deltaY = maximumCoord.func_177956_o() - minimumCoord.func_177956_o() + 1;
        int deltaZ = maximumCoord.func_177952_p() - minimumCoord.func_177952_p() + 1;
        int maxX = this.getSizeLimits().getMaximumXSize();
        int maxY = this.getSizeLimits().getMaximumYSize();
        int maxZ = this.getSizeLimits().getMaximumZSize();
        if (maxX > 0 && deltaX > maxX) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.large.x", maxX));
        }
        if (maxY > 0 && deltaY > maxY) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.large.y", maxY));
        }
        if (maxZ > 0 && deltaZ > maxZ) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.large.z", maxZ));
        }
        if (deltaX < minX) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.small.x", minX));
        }
        if (deltaY < minY) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.small.y", minY));
        }
        if (deltaZ < minZ) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.small.z", minZ));
        }
        if (this.connectedParts.size() < this.getSizeLimits().getMinimumNumberOfBlocksForAssembledMachine()) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.greenhouse.error.space.closed", minX, minY, minZ));
        }
        boolean isNextRoof = false;
        Class<?> myClass = this.getClass();
        block0: for (int y = minimumCoord.func_177956_o(); y <= maximumCoord.func_177956_o(); ++y) {
            for (int x = minimumCoord.func_177958_n(); x <= maximumCoord.func_177958_n(); ++x) {
                for (int z = minimumCoord.func_177952_p(); z <= maximumCoord.func_177952_p(); ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    TileEntity te = this.worldObj.func_175625_s(pos);
                    IMultiblockComponent part = te instanceof IMultiblockComponent ? (IMultiblockComponent)te : null;
                    int extremes = 0;
                    int sides = 0;
                    if (x == minimumCoord.func_177958_n()) {
                        ++extremes;
                        ++sides;
                    }
                    if (y == minimumCoord.func_177956_o()) {
                        ++extremes;
                    }
                    if (z == minimumCoord.func_177952_p()) {
                        ++extremes;
                        ++sides;
                    }
                    if (x == maximumCoord.func_177958_n()) {
                        ++extremes;
                        ++sides;
                    }
                    if (z == maximumCoord.func_177952_p()) {
                        ++extremes;
                        ++sides;
                    }
                    if (extremes >= 1) {
                        BlockPos posUp = pos.func_177984_a();
                        TileEntity tileUp = this.worldObj.func_175625_s(posUp);
                        if (sides >= 1 && !(tileUp instanceof IGreenhouseComponent)) {
                            int delta = y - minimumCoord.func_177956_o();
                            if (delta + 1 < minY) break block0;
                            isNextRoof = true;
                            break block0;
                        }
                        int exteriorLevel = y - minimumCoord.func_177956_o();
                        if (part != null) {
                            if (!myClass.equals(part.getMultiblockLogic().getController().getClass())) {
                                throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.invalid.part", Translator.translateToLocal(this.getUnlocalizedType())));
                            }
                            this.isGoodForExteriorLevel(part, exteriorLevel);
                            continue;
                        }
                        this.isBlockGoodForExteriorLevel(exteriorLevel, this.worldObj, pos);
                        continue;
                    }
                    if (part != null) {
                        IBlockState state = this.worldObj.func_180495_p(part.getCoordinates());
                        if (state.func_177230_c() instanceof BlockGreenhouse && ((BlockGreenhouse)state.func_177230_c()).getGreenhouseType() == BlockGreenhouseType.SPRINKLER || !myClass.equals(part.getMultiblockLogic().getController().getClass())) {
                            this.isGoodForInterior(part);
                            continue;
                        }
                        throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.invalid.part", Translator.translateToLocal(this.getUnlocalizedType())));
                    }
                    this.isBlockGoodForInterior(this.worldObj, pos);
                }
            }
        }
        this.internalBlocks.clear();
        if (isNextRoof) {
            Stack<IInternalBlock> blocksToCheck = new Stack<IInternalBlock>();
            IInternalBlock internalBlock = this.createInternalBlock(new InternalBlock(this.getMinimumCoord().func_177982_a(1, 1, 1)));
            blocksToCheck.add(internalBlock);
            while (!blocksToCheck.isEmpty()) {
                IInternalBlock blockToCheck = (IInternalBlock)blocksToCheck.pop();
                List<IInternalBlock> newBlocksToCheck = this.checkInternalBlock(blockToCheck);
                blocksToCheck.addAll(newBlocksToCheck);
            }
        }
        if (this.internalBlocks.isEmpty()) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.greenhouse.error.space.closed", new Object[0]));
        }
        int hatches = 0;
        for (IMultiblockComponent comp : this.connectedParts) {
            if (!(comp instanceof IGreenhouseComponent.ButterflyHatch)) continue;
            ++hatches;
        }
        if (hatches > 1) {
            throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.greenhouse.error.butterflyhatch.toomany", new Object[0]));
        }
    }

    @Override
    protected void updateClient(int tickCount) {
    }

    private List<IInternalBlock> checkInternalBlock(IInternalBlock blockToCheck) throws MultiblockValidationException {
        ArrayList<IInternalBlock> newBlocksToCheck = new ArrayList<IInternalBlock>();
        this.internalBlocks.add(blockToCheck);
        BlockPos posRoot = blockToCheck.getPos();
        this.isBlockGoodForInterior(this.worldObj, posRoot);
        for (IInternalBlockFace faceToCheck : blockToCheck.getFaces()) {
            GreenhouseEvents.CheckInternalBlockFaceEvent checkEvent = new GreenhouseEvents.CheckInternalBlockFaceEvent(this.createState(), blockToCheck, faceToCheck);
            MinecraftForge.EVENT_BUS.post((Event)checkEvent);
            if (faceToCheck.isTested()) continue;
            EnumFacing face = faceToCheck.getFace();
            BlockPos posFacing = posRoot.func_177972_a(face);
            BlockPos minPos = this.getMinimumCoord();
            BlockPos maxPos = this.getMaximumCoord();
            if (minPos.func_177958_n() > posFacing.func_177958_n() || minPos.func_177956_o() > posFacing.func_177956_o() || minPos.func_177952_p() > posFacing.func_177952_p() || maxPos.func_177958_n() < posFacing.func_177958_n() || maxPos.func_177956_o() < posFacing.func_177956_o() || maxPos.func_177952_p() < posFacing.func_177952_p()) {
                throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.greenhouse.error.space.closed", new Object[0]));
            }
            TileEntity tileFace = this.worldObj.func_175625_s(posFacing);
            if (tileFace instanceof IGreenhouseComponent) {
                if (((IGreenhouseComponent)tileFace).getMultiblockLogic().getController() != this) {
                    throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.not.connected.part", new Object[0]));
                }
                if (tileFace instanceof TileGreenhouseSprinkler) continue;
                faceToCheck.setTested(true);
                continue;
            }
            IInternalBlock internalBlock = this.createInternalBlock(new InternalBlock(posFacing, face.func_176734_d(), blockToCheck));
            if (this.internalBlocks.contains(internalBlock)) {
                faceToCheck.setTested(true);
                continue;
            }
            newBlocksToCheck.add(internalBlock);
        }
        return newBlocksToCheck;
    }

    private IInternalBlock createInternalBlock(IInternalBlock internalBlock) {
        GreenhouseEvents.CreateInternalBlockEvent createEvent = new GreenhouseEvents.CreateInternalBlockEvent(this.createState(), internalBlock);
        MinecraftForge.EVENT_BUS.post((Event)createEvent);
        return createEvent.internalBlock;
    }

    @Override
    public List<IInternalBlock> getInternalBlocks() {
        return this.internalBlocks;
    }

    public static IGreenhouseComponent.ButterflyHatch getGreenhouseButterflyHatch(World world, BlockPos pos) {
        if (GreenhouseManager.greenhouseHelper.getGreenhouseState(world, pos) == null) {
            return null;
        }
        IGreenhouseState state = GreenhouseManager.greenhouseHelper.getGreenhouseState(world, pos);
        for (IMultiblockComponent greenhouse : state.getGreenhouseComponents()) {
            if (!(greenhouse instanceof IGreenhouseComponent.ButterflyHatch)) continue;
            return (IGreenhouseComponent.ButterflyHatch)greenhouse;
        }
        return null;
    }

    @Override
    protected void isGoodForExteriorLevel(IMultiblockComponent part, int level) throws MultiblockValidationException {
    }

    @Override
    protected void isGoodForInterior(IMultiblockComponent part) throws MultiblockValidationException {
    }

    @Override
    protected void isBlockGoodForInterior(World world, BlockPos pos) throws MultiblockValidationException {
    }
}

