/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.circuits.ICircuit;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.PostManager;
import forestry.api.recipes.RecipeManagers;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.ISaveEventHandler;
import forestry.core.PluginCore;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.config.Config;
import forestry.core.fluids.Fluids;
import forestry.core.items.EnumElectronTube;
import forestry.core.network.IPacketRegistry;
import forestry.core.recipes.RecipeUtil;
import forestry.mail.EventHandlerMailAlert;
import forestry.mail.PostRegistry;
import forestry.mail.PostalCarrier;
import forestry.mail.SaveEventHandlerMail;
import forestry.mail.blocks.BlockRegistryMail;
import forestry.mail.commands.CommandMail;
import forestry.mail.items.EnumStampDefinition;
import forestry.mail.items.ItemRegistryMail;
import forestry.mail.network.PacketRegistryMail;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

@ForestryPlugin(pluginID="forestry.mail", name="Mail", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.mail.description")
public class PluginMail
extends BlankForestryPlugin {
    public static ItemRegistryMail items;
    public static BlockRegistryMail blocks;

    @Override
    public void setupAPI() {
        PostManager.postRegistry = new PostRegistry();
        PostManager.postRegistry.registerCarrier(new PostalCarrier(EnumAddressee.PLAYER));
        PostManager.postRegistry.registerCarrier(new PostalCarrier(EnumAddressee.TRADER));
    }

    @Override
    public void registerItemsAndBlocks() {
        items = new ItemRegistryMail();
        blocks = new BlockRegistryMail();
    }

    @Override
    public void preInit() {
        super.preInit();
        PluginCore.rootCommand.addChildCommand(new CommandMail());
        if (Config.mailAlertEnabled) {
            MinecraftForge.EVENT_BUS.register((Object)new EventHandlerMailAlert());
        }
    }

    @Override
    public void doInit() {
        super.doInit();
        PluginMail.blocks.mailbox.init();
        PluginMail.blocks.tradeStation.init();
        PluginMail.blocks.stampCollector.init();
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryMail();
    }

    @Override
    public void registerRecipes() {
        Item letterGlue;
        Item stampGlue;
        ItemRegistryApiculture beeItems = PluginApiculture.items;
        if (beeItems != null) {
            stampGlue = beeItems.honeyDrop;
            letterGlue = beeItems.propolis.getWildcard();
        } else {
            stampGlue = Items.field_151123_aH;
            letterGlue = Items.field_151123_aH;
        }
        RecipeUtil.addShapelessRecipe(PluginMail.items.letters.getItemStack(), Items.field_151121_aF, letterGlue);
        if (Config.craftingStampsEnabled) {
            for (EnumStampDefinition stampDefinition : EnumStampDefinition.VALUES) {
                if (Config.collectorStamps.contains(stampDefinition.getUid())) continue;
                ItemStack stamps = PluginMail.items.stamps.get(stampDefinition, 9);
                RecipeUtil.addRecipe(stamps, "XXX", "###", "ZZZ", Character.valueOf('X'), stampDefinition.getCraftingIngredient(), Character.valueOf('#'), Items.field_151121_aF, Character.valueOf('Z'), stampGlue);
                RecipeManagers.carpenterManager.addRecipe(10, Fluids.SEED_OIL.getFluid(300), null, stamps, "XXX", "###", Character.valueOf('X'), stampDefinition.getCraftingIngredient(), Character.valueOf('#'), Items.field_151121_aF);
            }
        }
        RecipeUtil.addRecipe(new ItemStack(Items.field_151121_aF), "###", Character.valueOf('#'), "emptiedLetter");
        RecipeManagers.carpenterManager.addRecipe(10, Fluids.WATER.getFluid(250), null, PluginMail.items.letters.getItemStack(), "###", "###", Character.valueOf('#'), PluginCore.items.woodPulp);
        RecipeUtil.addShapelessRecipe(PluginMail.items.catalogue.getItemStack(), PluginMail.items.stamps.getWildcard(), new ItemStack(Items.field_151122_aG));
        RecipeUtil.addRecipe(new ItemStack((Block)PluginMail.blocks.mailbox), " # ", "#Y#", "XXX", Character.valueOf('#'), "ingotTin", Character.valueOf('X'), "chestWood", Character.valueOf('Y'), PluginCore.items.sturdyCasing);
        RecipeUtil.addRecipe(new ItemStack((Block)PluginMail.blocks.tradeStation), "Z#Z", "#Y#", "XWX", Character.valueOf('#'), PluginCore.items.tubes.get(EnumElectronTube.BRONZE, 1), Character.valueOf('X'), "chestWood", Character.valueOf('Y'), PluginCore.items.sturdyCasing, Character.valueOf('Z'), PluginCore.items.tubes.get(EnumElectronTube.IRON, 1), Character.valueOf('W'), ItemCircuitBoard.createCircuitboard(EnumCircuitBoardType.REFINED, null, new ICircuit[0]));
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerMail();
    }
}

