package forestry.core.items;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.FoodStats;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ItemLiquidContainerDrinkable extends ItemLiquidContainer {
	private final DrinkProperties properties;

	public ItemLiquidContainerDrinkable(EnumContainerType type, int color, DrinkProperties properties) {
		super(type, color);
		this.properties = properties;
	}

	@Override
	public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
		if (entityLiving instanceof EntityPlayer && !((EntityPlayer)entityLiving).field_71075_bZ.field_75098_d) {
			EntityPlayer player = (EntityPlayer) entityLiving;
			if (!player.field_71075_bZ.field_75098_d) {
				--stack.field_77994_a;
			}

			if (!worldIn.field_72995_K) {
				FoodStats foodStats = player.func_71024_bL();
				foodStats.func_75122_a(properties.getHealAmount(), properties.getSaturationModifier());
				worldIn.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5F, worldIn.field_73012_v.nextFloat() * 0.1F + 0.9F);
			}

			player.func_71029_a(StatList.func_188057_b(this));
		}

		return stack;
	}

	@Override
	public int func_77626_a(ItemStack itemstack) {
		return properties.getMaxItemUseDuration();
	}

	@Override
	public EnumAction func_77661_b(ItemStack itemstack) {
		return EnumAction.DRINK;
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
		if (playerIn.func_71043_e(false)) {
			playerIn.func_184598_c(hand);
			return new ActionResult<>(EnumActionResult.SUCCESS, itemStackIn);
		} else {
			return new ActionResult<>(EnumActionResult.FAIL, itemStackIn);
		}
	}
}
