/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.IStillManager;
import forestry.api.recipes.IStillRecipe;
import forestry.factory.recipes.StillRecipe;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class StillRecipeManager
implements IStillManager {
    private static final Set<IStillRecipe> recipes = new HashSet<IStillRecipe>();
    public static final Set<Fluid> recipeFluidInputs = new HashSet<Fluid>();
    public static final Set<Fluid> recipeFluidOutputs = new HashSet<Fluid>();

    @Override
    public void addRecipe(int timePerUnit, FluidStack input, FluidStack output) {
        StillRecipe recipe = new StillRecipe(timePerUnit, input, output);
        this.addRecipe(recipe);
    }

    public static IStillRecipe findMatchingRecipe(FluidStack item) {
        if (item == null) {
            return null;
        }
        for (IStillRecipe recipe : recipes) {
            if (!StillRecipeManager.matches(recipe, item)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean matches(IStillRecipe recipe, FluidStack item) {
        if (recipe == null || item == null) {
            return false;
        }
        return item.containsFluid(recipe.getInput());
    }

    @Override
    public boolean addRecipe(IStillRecipe recipe) {
        FluidStack input = recipe.getInput();
        recipeFluidInputs.add(input.getFluid());
        FluidStack output = recipe.getOutput();
        recipeFluidOutputs.add(output.getFluid());
        return recipes.add(recipe);
    }

    @Override
    public boolean removeRecipe(IStillRecipe recipe) {
        FluidStack input = recipe.getInput();
        recipeFluidInputs.remove(input.getFluid());
        FluidStack output = recipe.getOutput();
        recipeFluidOutputs.remove(output.getFluid());
        return recipes.remove(recipe);
    }

    @Override
    public Set<IStillRecipe> recipes() {
        return Collections.unmodifiableSet(recipes);
    }
}

