/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.multiblock;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;

import javax.annotation.Nonnull;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

import com.mojang.authlib.GameProfile;

import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.access.AccessHandler;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.ILocatable;

public abstract class MultiblockControllerForestry extends MultiblockControllerBase implements ISidedInventory, IRestrictedAccess, IErrorLogicSource, ILocatable {
	private final AccessHandler accessHandler;
	private final IErrorLogic errorLogic;

	protected MultiblockControllerForestry(World world) {
		super(world);

		this.accessHandler = new AccessHandler(this);
		this.errorLogic = ForestryAPI.errorStateRegistry.createErrorLogic();
	}

	@Override
	public IAccessHandler getAccessHandler() {
		return accessHandler;
	}

	@Override
	public IErrorLogic getErrorLogic() {
		return errorLogic;
	}

	@Override
	public World getWorldObj() {
		return worldObj;
	}

	@Override
	protected void onMachineAssembled() {
		super.onMachineAssembled();

		if (worldObj.field_72995_K) {
			return;
		}

		// Figure out who owns the multiblock, by majority

		Multiset<GameProfile> owners = HashMultiset.create();
		for (IMultiblockComponent part : connectedParts) {
			GameProfile owner = part.getOwner();
			if (owner != null) {
				owners.add(owner);
			}
		}

		GameProfile owner = null;
		int max = 0;
		for (Multiset.Entry<GameProfile> entry : owners.entrySet()) {
			int count = entry.getCount();
			if (count > max) {
				max = count;
				owner = entry.getElement();
			}
		}

		getAccessHandler().setOwner(owner);
	}

	/* INbtWritable */
	@Override
	public NBTTagCompound writeToNBT(NBTTagCompound data) {
		accessHandler.writeToNBT(data);
		return data;
	}

	@Override
	public void readFromNBT(NBTTagCompound data) {
		accessHandler.readFromNBT(data);
	}

	/* INVENTORY */
	@Nonnull
	public IInventoryAdapter getInternalInventory() {
		return FakeInventoryAdapter.instance();
	}

	@Override
	public void func_70296_d() {
		getInternalInventory().func_70296_d();
	}

	@Override
	public final int func_70302_i_() {
		return getInternalInventory().func_70302_i_();
	}

	@Override
	public final ItemStack func_70301_a(int slotIndex) {
		return getInternalInventory().func_70301_a(slotIndex);
	}

	@Override
	public final ItemStack func_70298_a(int slotIndex, int amount) {
		return getInternalInventory().func_70298_a(slotIndex, amount);
	}
	
	@Override
	public ItemStack func_70304_b(int slotIndex) {
		return getInternalInventory().func_70304_b(slotIndex);
	}

	@Override
	public final void func_70299_a(int slotIndex, ItemStack itemstack) {
		getInternalInventory().func_70299_a(slotIndex, itemstack);
	}

	@Override
	public final int func_70297_j_() {
		return getInternalInventory().func_70297_j_();
	}

	@Override
	public final void func_174889_b(EntityPlayer player) {
		getInternalInventory().func_174889_b(player);
	}

	@Override
	public final void func_174886_c(EntityPlayer player) {
		getInternalInventory().func_174886_c(player);
	}
	
	@Override
	public String func_70005_c_() {
		return getInternalInventory().func_70005_c_();
	}
	
	@Override
	public ITextComponent func_145748_c_() {
		return getInternalInventory().func_145748_c_();
	}

	@Override
	public final boolean func_70300_a(EntityPlayer player) {
		return getInternalInventory().func_70300_a(player);
	}
	
	@Override
	public boolean func_145818_k_() {
		return getInternalInventory().func_145818_k_();
	}

	@Override
	public final boolean func_94041_b(int slotIndex, ItemStack itemStack) {
		return getInternalInventory().func_94041_b(slotIndex, itemStack);
	}
	
	@Override
	public int[] func_180463_a(EnumFacing side) {
		return getInternalInventory().func_180463_a(side);
	}

	@Override
	public final boolean func_180462_a(int slotIndex, ItemStack itemStack, EnumFacing side) {
		return getInternalInventory().func_180462_a(slotIndex, itemStack, side);
	}

	@Override
	public final boolean func_180461_b(int slotIndex, ItemStack itemStack, EnumFacing side) {
		return getInternalInventory().func_180461_b(slotIndex, itemStack, side);
	}
	
	@Override
	public int func_174887_a_(int id) {
		return getInternalInventory().func_174887_a_(id);
	}
	
	@Override
	public int func_174890_g() {
		return getInternalInventory().func_174890_g();
	}
	
	@Override
	public void func_174885_b(int id, int value) {
		getInternalInventory().func_174885_b(id, value);
	}
	
	@Override
	public void func_174888_l() {
		getInternalInventory().func_174888_l();
	}
}
