/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.core.IItemModelRegister;
import forestry.core.CreativeTabForestry;
import forestry.core.access.IOwnable;
import forestry.core.access.IRestrictedAccess;
import forestry.core.tiles.TileForestry;
import forestry.core.utils.Log;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class BlockForestry
extends Block
implements IItemModelRegister,
ITileEntityProvider {
    protected BlockForestry(Material material) {
        super(material);
        this.func_149711_c(1.5f);
        this.func_149647_a(CreativeTabForestry.tabForestry);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        IRestrictedAccess restrictedAccessTile;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IRestrictedAccess && !(restrictedAccessTile = (IRestrictedAccess)tile).getAccessHandler().allowsRemoval(player)) {
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        if (placer instanceof EntityPlayer) {
            IOwnable ownable;
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof IRestrictedAccess) {
                ownable = ((IRestrictedAccess)tile).getAccessHandler();
            } else if (tile instanceof IOwnable) {
                ownable = (IOwnable)tile;
            } else {
                return;
            }
            EntityPlayer player = (EntityPlayer)placer;
            GameProfile gameProfile = player.func_146103_bH();
            ownable.setOwner(gameProfile);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        try {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof TileForestry) {
                ((TileForestry)tile).onNeighborBlockChange(state.func_177230_c());
            }
        }
        catch (StackOverflowError error) {
            Log.error("Stack Overflow Error in BlockMachine.onNeighborBlockChange()", error);
            throw error;
        }
    }
}

