/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.mail.tiles;

import javax.annotation.Nonnull;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

import com.mojang.authlib.GameProfile;

import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostalState;
import forestry.api.mail.PostManager;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.tiles.TileBase;
import forestry.mail.EnumDeliveryState;
import forestry.mail.POBox;
import forestry.mail.PostRegistry;
import forestry.mail.gui.ContainerMailbox;
import forestry.mail.gui.GuiMailbox;

public class TileMailbox extends TileBase implements IMailContainer {

	private boolean isLinked = false;

	public TileMailbox() {
		super("mailbox");
		setInternalInventory(new InventoryAdapter(POBox.SLOT_SIZE, "Letters").disableAutomation());
	}

	/* GUI */
	@Override
	public void openGui(EntityPlayer player, ItemStack heldItem) {
		if (field_145850_b.field_72995_K) {
			return;
		}

		// Handle letter sending
		if (PostManager.postRegistry.isLetter(heldItem)) {
			IPostalState result = this.tryDispatchLetter(heldItem);
			if (!result.isOk()) {
				player.func_145747_a(new TextComponentString(result.getDescription()));
			} else {
				heldItem.field_77994_a--;
			}
		} else {
			super.openGui(player, heldItem);
		}
	}

	/* UPDATING */
	@Override
	public void updateServerSide() {
		if (!isLinked) {
			GameProfile owner = getAccessHandler().getOwner();
			if (owner != null) {
				getOrCreateMailInventory(field_145850_b, owner);
			}
			isLinked = true;
		}
	}

	/* MAIL HANDLING */
	public IInventory getOrCreateMailInventory(World world, @Nonnull GameProfile playerProfile) {
		if (world.field_72995_K) {
			return getInternalInventory();
		}

		IMailAddress address = PostManager.postRegistry.getMailAddress(playerProfile);
		return PostRegistry.getOrCreatePOBox(field_145850_b, address);
	}

	private IPostalState tryDispatchLetter(ItemStack letterStack) {
		ILetter letter = PostManager.postRegistry.getLetter(letterStack);
		IPostalState result;

		if (letter != null) {
			result = PostManager.postRegistry.getPostOffice(field_145850_b).lodgeLetter(field_145850_b, letterStack, true);
		} else {
			result = EnumDeliveryState.NOT_MAILABLE;
		}

		return result;
	}

	@Override
	public boolean hasMail() {
		GameProfile owner = getAccessHandler().getOwner();
		if (owner == null) {
			return false;
		}
		IInventory mailInventory = getOrCreateMailInventory(field_145850_b, owner);
		for (int i = 0; i < mailInventory.func_70302_i_(); i++) {
			if (mailInventory.func_70301_a(i) != null) {
				return true;
			}
		}

		return false;
	}

	// TODO: Buildcraft for 1.9
//	@Optional.Method(modid = "BuildCraftAPI|statements")
//	@Override
//	public Collection<ITriggerExternal> getExternalTriggers(EnumFacing side, TileEntity tile) {
//		LinkedList<ITriggerExternal> res = new LinkedList<>();
//		res.add(MailTriggers.triggerHasMail);
//		return res;
//	}

	@Override
	public Object getGui(EntityPlayer player, int data) {
		return new GuiMailbox(player.field_71071_by, this);
	}

	@Override
	public Object getContainer(EntityPlayer player, int data) {
		return new ContainerMailbox(player.field_71071_by, this);
	}
}
