/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IAlleleButterflySpeciesBuilder;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyMutationBuilder;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.lepidopterology.genetics.Butterfly;
import forestry.lepidopterology.genetics.ButterflyBranchDefinition;
import forestry.lepidopterology.genetics.ButterflyDefinition;
import forestry.lepidopterology.genetics.IButterflyDefinition;
import forestry.lepidopterology.genetics.alleles.AlleleButterflyCocoon;
import java.awt.Color;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.item.ItemStack;

public enum MothDefinition implements IButterflyDefinition
{
    Brimstone(ButterflyBranchDefinition.Opisthograptis, "brimstone", "luteolata", new Color(16771648), true, 1.0f),
    LatticedHeath(ButterflyBranchDefinition.Chiasmia, "latticeHeath", "clathrata", new Color(15921342), true, 0.5f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.SMALLEST);
        }
    }
    ,
    Atlas(ButterflyBranchDefinition.Attacus, "atlas", "atlas", new Color(14249533), false, 0.1f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.LARGEST);
        }
    }
    ,
    BombyxMori(ButterflyBranchDefinition.Bombyx, "bombyxMori", "bombyxMori", new Color(0xDADADA), false, 0.0f){

        @Override
        protected void setAlleles(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, EnumButterflyChromosome.SIZE, EnumAllele.Size.SMALLEST);
            AlleleHelper.instance.set(alleles, EnumButterflyChromosome.SPEED, EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(alleles, EnumButterflyChromosome.METABOLISM, 4);
            AlleleHelper.instance.set(alleles, EnumButterflyChromosome.COCOON, AlleleButterflyCocoon.cocoonSilk);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(LatticedHeath, ButterflyDefinition.Brimstone, 7);
        }
    };

    private final IAlleleButterflySpecies species;
    private final ButterflyBranchDefinition branch;
    private IAllele[] template;
    private IButterflyGenome genome;

    private MothDefinition(ButterflyBranchDefinition branchDefinition, String speciesName, String binomial, Color serumColor, boolean dominant, float rarity) {
        this.branch = branchDefinition;
        String uid = "moth" + this.name();
        IClassification parent = this.branch.getBranch().getParent();
        String unlocalizedName = "for.butterflies.species." + parent.getUID().substring(parent.getLevel().name().toLowerCase(Locale.ENGLISH).length() + 1) + '.' + speciesName;
        String unlocalizedDescription = "for.description." + uid;
        String texture = "butterflies/" + uid;
        IAlleleButterflySpeciesBuilder speciesBuilder = ButterflyManager.butterflyFactory.createSpecies("forestry." + uid, unlocalizedName, "Sengir", unlocalizedDescription, "forestry", texture, dominant, branchDefinition.getBranch(), binomial, serumColor);
        speciesBuilder.setRarity(rarity);
        speciesBuilder.setNocturnal();
        this.setSpeciesProperties(speciesBuilder);
        this.species = speciesBuilder.build();
    }

    public static void initMoths() {
        for (MothDefinition butterfly : MothDefinition.values()) {
            butterfly.init();
        }
        for (MothDefinition butterfly : MothDefinition.values()) {
            butterfly.registerMutations();
        }
    }

    private void init() {
        this.template = this.branch.getTemplate();
        AlleleHelper.instance.set(this.template, EnumButterflyChromosome.SPECIES, this.species);
        this.setAlleles(this.template);
        this.genome = ButterflyManager.butterflyRoot.templateAsGenome(this.template);
        ButterflyManager.butterflyRoot.registerTemplate(this.template);
    }

    protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
    }

    protected void setAlleles(IAllele[] alleles) {
    }

    protected void registerMutations() {
    }

    protected final IButterflyMutationBuilder registerMutation(IButterflyDefinition parent1, IButterflyDefinition parent2, int chance) {
        IAlleleButterflySpecies species1 = null;
        IAlleleButterflySpecies species2 = null;
        if (parent1 instanceof MothDefinition) {
            species1 = ((MothDefinition)parent1).species;
        } else if (parent1 instanceof ButterflyDefinition) {
            species1 = ((ButterflyDefinition)parent1).getSpecies();
        }
        if (parent2 instanceof MothDefinition) {
            species2 = ((MothDefinition)parent2).species;
        } else if (parent2 instanceof ButterflyDefinition) {
            species2 = ((ButterflyDefinition)parent2).getSpecies();
        }
        return ButterflyManager.butterflyMutationFactory.createMutation(species1, species2, this.getTemplate(), chance);
    }

    @Override
    public final IAllele[] getTemplate() {
        return Arrays.copyOf(this.template, this.template.length);
    }

    @Override
    public final IButterflyGenome getGenome() {
        return this.genome;
    }

    @Override
    public final IButterfly getIndividual() {
        return new Butterfly(this.genome);
    }

    @Override
    public final ItemStack getMemberStack(EnumFlutterType flutterType) {
        IButterfly butterfly = this.getIndividual();
        return ButterflyManager.butterflyRoot.getMemberStack(butterfly, flutterType);
    }

    public IAlleleButterflySpecies getSpecies() {
        return this.species;
    }
}

