/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks.planks;

import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodHelper;
import forestry.arboriculture.blocks.WoodTypeStateMapper;
import forestry.arboriculture.blocks.property.PropertyWoodType;
import forestry.core.proxy.Proxies;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockForestryPlanks<T extends Enum<T>>
extends Block
implements IWoodTyped,
IStateMapperRegister,
IItemModelRegister {
    protected static final int VARIANTS_PER_BLOCK = 16;
    protected static final int VARIANTS_META_MASK = 15;
    private final boolean fireproof;
    private final int blockNumber;

    protected BlockForestryPlanks(boolean fireproof, int blockNumber) {
        super(Material.field_151575_d);
        this.fireproof = fireproof;
        this.blockNumber = blockNumber;
        PropertyWoodType<T> variant = this.getVariant();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(variant, variant.getFirstType()));
        this.func_149752_b(5.0f);
        this.setHarvestLevel("axe", 0);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(Tabs.tabArboriculture);
    }

    @Override
    public boolean isFireproof() {
        return this.fireproof;
    }

    @Nonnull
    public abstract PropertyWoodType<T> getVariant();

    @Nonnull
    public abstract T getWoodType(int var1);

    public int getBlockNumber() {
        return this.blockNumber;
    }

    @Override
    @Nonnull
    public WoodBlockKind getBlockKind() {
        return WoodBlockKind.PLANKS;
    }

    public IBlockState func_176203_a(int meta) {
        T woodType = this.getWoodType(meta);
        return this.func_176223_P().func_177226_a(this.getVariant(), woodType);
    }

    @Nonnull
    public Collection<T> getWoodTypes() {
        return this.getVariant().func_177700_c();
    }

    public int func_176201_c(IBlockState state) {
        return this.func_180651_a(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getVariant()});
    }

    public int func_180651_a(IBlockState state) {
        return ((IWoodType)((Object)((Enum)((Object)state.func_177229_b(this.getVariant()))))).getMetadata() - this.blockNumber * 16;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        T woodType = this.getWoodType(meta);
        return this.func_176223_P().func_177226_a(this.getVariant(), woodType);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (Enum woodType : this.getVariant().func_177700_c()) {
            list.add(TreeManager.woodAccess.getStack((IWoodType)((Object)woodType), this.getBlockKind(), this.fireproof));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])WoodHelper.getResourceLocations(this));
        manager.registerItemModel(item, new WoodHelper.WoodMeshDefinition(this));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void registerStateMapper() {
        Proxies.render.registerStateMapper(this, (IStateMapper)new WoodTypeStateMapper(this, this.getVariant()));
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        int meta = this.func_176201_c(blockState);
        T woodType = this.getWoodType(meta);
        return ((IWoodType)woodType).getHardness();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.fireproof) {
            return 0;
        }
        return 20;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.fireproof) {
            return 0;
        }
        return 5;
    }
}

