/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import com.mojang.authlib.GameProfile;
import forestry.api.multiblock.IMultiblockLogic;
import forestry.api.multiblock.MultiblockTileEntityBase;
import forestry.core.config.Constants;
import forestry.core.gui.GuiHandler;
import forestry.core.gui.IGuiHandlerTile;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.IFilterSlotDelegate;
import forestry.core.tiles.ILocatable;
import forestry.core.utils.PlayerUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public abstract class MultiblockTileEntityForestry<T extends IMultiblockLogic>
extends MultiblockTileEntityBase<T>
implements ISidedInventory,
IFilterSlotDelegate,
ILocatable,
IGuiHandlerTile {
    @Nullable
    private GameProfile owner;

    public MultiblockTileEntityForestry(T multiblockLogic) {
        super(multiblockLogic);
    }

    public void openGui(EntityPlayer player) {
        GuiHandler.openGui(player, this);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("owner")) {
            NBTTagCompound ownerNbt = data.func_74775_l("owner");
            this.owner = PlayerUtil.readGameProfileFromNBT(ownerNbt);
        }
        this.getInternalInventory().readFromNBT(data);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        data = super.func_189515_b(data);
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            PlayerUtil.writeGameProfile(nbt, this.owner);
            data.func_74782_a("owner", (NBTBase)nbt);
        }
        this.getInternalInventory().writeToNBT(data);
        return data;
    }

    public IInventoryAdapter getInternalInventory() {
        return FakeInventoryAdapter.instance();
    }

    public boolean allowsAutomation() {
        return false;
    }

    public final int func_70302_i_() {
        return this.getInternalInventory().func_70302_i_();
    }

    public final ItemStack func_70301_a(int slotIndex) {
        return this.getInternalInventory().func_70301_a(slotIndex);
    }

    public final ItemStack func_70298_a(int slotIndex, int amount) {
        return this.getInternalInventory().func_70298_a(slotIndex, amount);
    }

    public ItemStack func_70304_b(int slotIndex) {
        return this.getInternalInventory().func_70304_b(slotIndex);
    }

    public final void func_70299_a(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().func_70299_a(slotIndex, itemstack);
    }

    public final int func_70297_j_() {
        return this.getInternalInventory().func_70297_j_();
    }

    public final void func_174889_b(EntityPlayer player) {
        this.getInternalInventory().func_174889_b(player);
    }

    public final void func_174886_c(EntityPlayer player) {
        this.getInternalInventory().func_174886_c(player);
    }

    public final String func_70005_c_() {
        return this.getInternalInventory().func_70005_c_();
    }

    public ITextComponent func_145748_c_() {
        return this.getInternalInventory().func_145748_c_();
    }

    public final boolean func_70300_a(EntityPlayer player) {
        return this.getInternalInventory().func_70300_a(player);
    }

    public final boolean func_145818_k_() {
        return this.getInternalInventory().func_145818_k_();
    }

    public final boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().func_94041_b(slotIndex, itemStack);
    }

    public int[] func_180463_a(EnumFacing side) {
        if (this.allowsAutomation()) {
            return this.getInternalInventory().func_180463_a(side);
        }
        return Constants.SLOTS_NONE;
    }

    public final boolean func_180462_a(int slotIndex, ItemStack itemStack, EnumFacing side) {
        if (this.allowsAutomation()) {
            return this.getInternalInventory().func_180462_a(slotIndex, itemStack, side);
        }
        return false;
    }

    public final boolean func_180461_b(int slotIndex, ItemStack itemStack, EnumFacing side) {
        if (this.allowsAutomation()) {
            return this.getInternalInventory().func_180461_b(slotIndex, itemStack, side);
        }
        return false;
    }

    @Override
    public final boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public final boolean isLocked(int slotIndex) {
        return this.getInternalInventory().isLocked(slotIndex);
    }

    @Override
    public final World getWorldObj() {
        return this.field_145850_b;
    }

    @Override
    @Nonnull
    public final GameProfile getOwner() {
        return this.owner;
    }

    public final void setOwner(@Nonnull GameProfile owner) {
        this.owner = owner;
    }

    public int func_174887_a_(int id) {
        return this.getInternalInventory().func_174887_a_(id);
    }

    public int func_174890_g() {
        return this.getInternalInventory().func_174890_g();
    }

    public void func_174885_b(int id, int value) {
        this.getInternalInventory().func_174885_b(id, value);
    }

    public void func_174888_l() {
        this.getInternalInventory().func_174888_l();
    }
}

