package forestry.arboriculture.blocks.planks;

import javax.annotation.Nonnull;
import java.util.Collection;
import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodHelper;
import forestry.arboriculture.blocks.WoodTypeStateMapper;
import forestry.arboriculture.blocks.property.PropertyWoodType;
import forestry.core.proxy.Proxies;

public abstract class BlockForestryPlanks<T extends Enum<T> & IWoodType> extends Block implements IWoodTyped, IStateMapperRegister, IItemModelRegister {
	protected static final int VARIANTS_PER_BLOCK = 16;
	protected static final int VARIANTS_META_MASK = VARIANTS_PER_BLOCK - 1;

	private final boolean fireproof;
	private final int blockNumber;

	protected BlockForestryPlanks(boolean fireproof, int blockNumber) {
		super(Material.field_151575_d);
		this.fireproof = fireproof;
		this.blockNumber = blockNumber;

		PropertyWoodType<T> variant = getVariant();
		func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(variant, variant.getFirstType()));

		func_149752_b(5.0F);
		setHarvestLevel("axe", 0);
		func_149672_a(SoundType.field_185848_a);
		func_149647_a(Tabs.tabArboriculture);
	}

	@Override
	public boolean isFireproof() {
		return fireproof;
	}

	@Nonnull
	public abstract PropertyWoodType<T> getVariant();

	@Nonnull
	@Override
	public abstract T getWoodType(int meta);

	public int getBlockNumber() {
		return blockNumber;
	}

	@Nonnull
	@Override
	public WoodBlockKind getBlockKind() {
		return WoodBlockKind.PLANKS;
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		T woodType = getWoodType(meta);
		return func_176223_P().func_177226_a(getVariant(), woodType);
	}

	@Nonnull
	@Override
	public Collection<T> getWoodTypes() {
		return getVariant().func_177700_c();
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return func_180651_a(state);
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, getVariant());
	}

	@Override
	public int func_180651_a(IBlockState state) {
		return state.func_177229_b(getVariant()).getMetadata() - blockNumber * VARIANTS_PER_BLOCK;
	}

	@Override
	public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
		T woodType = getWoodType(meta);
		return func_176223_P().func_177226_a(getVariant(), woodType);
	}

	@Override
	public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
		for (T woodType : getVariant().func_177700_c()) {
			list.add(TreeManager.woodAccess.getStack(woodType, getBlockKind(), fireproof));
		}
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		ModelBakery.registerItemVariants(item, WoodHelper.getResourceLocations(this));
		manager.registerItemModel(item, new WoodHelper.WoodMeshDefinition(this));
	}

	@Override
	@SideOnly(Side.CLIENT)
	public final void registerStateMapper() {
		Proxies.render.registerStateMapper(this, new WoodTypeStateMapper(this, getVariant()));
	}

	@Override
	public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
		int meta = func_176201_c(blockState);
		T woodType = getWoodType(meta);
		return woodType.getHardness();
	}

	@Override
	public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
		if (fireproof) {
			return 0;
		}
		return 20;
	}

	@Override
	public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
		if (fireproof) {
			return 0;
		}
		return 5;
	}
}
