/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.core.recipes.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;

public class JEIUtils {

	public static List<ItemStack> getItemVariations(ItemStack base) {
		List<ItemStack> variations = new ArrayList<>();
		base.func_77973_b().func_150895_a(base.func_77973_b(), null, variations);
		Iterator<ItemStack> itr = variations.iterator();
		ItemStack stack;
		while (itr.hasNext()) {
			stack = itr.next();
			if (!base.func_77969_a(stack) || !stack.func_77942_o()) {
				itr.remove();
			}
		}
		if (variations.isEmpty()) {
			return Collections.singletonList(base);
		}
		return variations;
	}

	public static FluidStack getFluidStack(ItemStack stack) {
		if (stack != null) {
			FluidStack fluidStack = null;
			if (stack.func_77973_b() instanceof IFluidContainerItem) {
				fluidStack = ((IFluidContainerItem) stack.func_77973_b()).getFluid(stack);
			}
			if (fluidStack == null) {
				fluidStack = FluidContainerRegistry.getFluidForFilledItem(stack);
			}
			if (fluidStack == null && Block.func_149634_a(stack.func_77973_b()) instanceof IFluidBlock) {
				Fluid fluid = ((IFluidBlock) Block.func_149634_a(stack.func_77973_b())).getFluid();
				if (fluid != null) {
					fluidStack = new FluidStack(fluid, Fluid.BUCKET_VOLUME);
				}
			}
			return fluidStack;
		}
		return null;
	}

	public static boolean areFluidsSameType(FluidStack fluidStack1, FluidStack fluidStack2) {
		if (fluidStack1 == null || fluidStack2 == null) {
			return false;
		}
		return fluidStack1.getFluid() == fluidStack2.getFluid();
	}
}
