/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutationCondition;
import forestry.core.utils.Translator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class MutationConditionRequiresResourceOreDict
implements IMutationCondition {
    private final int oreDictId;
    private final String displayName;

    public MutationConditionRequiresResourceOreDict(String oreDictName) {
        this.oreDictId = OreDictionary.getOreID((String)oreDictName);
        List ores = OreDictionary.getOres((String)oreDictName);
        this.displayName = ores != null && !ores.isEmpty() ? ((ItemStack)ores.get(0)).func_82833_r() : oreDictName;
    }

    @Override
    public float getChance(World world, BlockPos pos, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        int[] oreIds;
        int meta;
        Block block;
        int i = 1;
        do {
            BlockPos blockPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() - i, pos.func_177956_o());
            IBlockState blockState = world.func_180495_p(blockPos);
            block = blockState.func_177230_c();
            meta = block.func_176201_c(blockState);
            ++i;
        } while (block instanceof IBeeHousing);
        for (int oreId : oreIds = OreDictionary.getOreIDs((ItemStack)new ItemStack(block, 1, meta))) {
            if (oreId != this.oreDictId) continue;
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public String getDescription() {
        return Translator.translateToLocalFormatted("for.mutation.condition.resource", this.displayName);
    }
}

