/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.fermenter;

import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.core.render.ForestryResource;
import forestry.factory.recipes.jei.fermenter.FermenterRecipeWrapper;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class FermenterRecipeCategory
extends ForestryRecipeCategory {
    private static final int resourceSlot = 0;
    private static final int fuelSlot = 1;
    private static final int inputTank = 0;
    private static final int outputTank = 1;
    private static final ResourceLocation guiTexture = new ForestryResource("textures/gui/fermenter.png");
    @Nonnull
    private final IDrawableAnimated progressBar0;
    @Nonnull
    private final IDrawableAnimated progressBar1;
    @Nonnull
    private final IDrawable tankOverlay;

    public FermenterRecipeCategory(IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createDrawable(guiTexture, 34, 18, 108, 60), "tile.for.fermenter.name");
        IDrawableStatic progressBarDrawable0 = guiHelper.createDrawable(guiTexture, 176, 60, 4, 18);
        this.progressBar0 = guiHelper.createAnimatedDrawable(progressBarDrawable0, 40, IDrawableAnimated.StartDirection.BOTTOM, false);
        IDrawableStatic progressBarDrawable1 = guiHelper.createDrawable(guiTexture, 176, 78, 4, 18);
        this.progressBar1 = guiHelper.createAnimatedDrawable(progressBarDrawable1, 80, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.tankOverlay = guiHelper.createDrawable(guiTexture, 192, 0, 16, 58);
    }

    @Nonnull
    public String getUid() {
        return "forestry.fermenter";
    }

    public void drawAnimations(@Nonnull Minecraft minecraft) {
        this.progressBar0.draw(minecraft, 40, 14);
        this.progressBar1.draw(minecraft, 64, 28);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 50, 4);
        guiItemStacks.init(1, true, 40, 38);
        guiFluidStacks.init(0, true, 1, 1, 16, 58, 3000, false, this.tankOverlay);
        guiFluidStacks.init(1, false, 91, 1, 16, 58, 3000, false, this.tankOverlay);
        FermenterRecipeWrapper wrapper = (FermenterRecipeWrapper)recipeWrapper;
        guiItemStacks.set(0, wrapper.getFermentable());
        ArrayList<ItemStack> fuels = new ArrayList<ItemStack>();
        for (FermenterFuel fuel : FuelManager.fermenterFuel.values()) {
            fuels.add(fuel.item);
        }
        guiItemStacks.set(1, fuels);
        guiFluidStacks.set(0, wrapper.getFluidInputs());
        guiFluidStacks.set(1, wrapper.getFluidOutputs());
    }
}

