package forestry.arboriculture.blocks.slab;

import javax.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Random;

import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodHelper;
import forestry.arboriculture.blocks.WoodTypeStateMapper;
import forestry.arboriculture.blocks.property.PropertyWoodType;
import forestry.core.proxy.Proxies;

import net.minecraft.block.BlockSlab.EnumBlockHalf;

public abstract class BlockForestrySlab<T extends Enum<T> & IWoodType> extends BlockSlab implements IWoodTyped, IItemModelRegister, IStateMapperRegister {
	protected static final int VARIANTS_PER_BLOCK = 8;
	protected static final int VARIANTS_META_MASK = VARIANTS_PER_BLOCK - 1;

	private final boolean fireproof;
	private final int blockNumber;

	protected BlockForestrySlab(boolean fireproof, int blockNumber) {
		super(Material.field_151575_d);
		this.fireproof = fireproof;
		this.blockNumber = blockNumber;

		IBlockState iblockstate = this.field_176227_L.func_177621_b();

		if (!func_176552_j()) {
			iblockstate = iblockstate.func_177226_a(field_176554_a, EnumBlockHalf.BOTTOM);
		}

		PropertyWoodType<T> variant = getVariant();
		func_180632_j(iblockstate.func_177226_a(variant, variant.getFirstType()));

		func_149647_a(Tabs.tabArboriculture);
		func_149713_g(0);
		func_149711_c(2.0F);
		func_149752_b(5.0F);
		func_149672_a(SoundType.field_185848_a);
		setHarvestLevel("axe", 0);
	}

	@Override
	public boolean isFireproof() {
		return fireproof;
	}

	@Nonnull
	public abstract PropertyWoodType<T> getVariant();

	public int getBlockNumber() {
		return blockNumber;
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return this.func_176552_j() ? new BlockStateContainer(this, getVariant()) : new BlockStateContainer(this, field_176554_a, getVariant());
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		T woodType = getWoodType(meta);
		IBlockState iblockstate = this.func_176223_P().func_177226_a(getVariant(), woodType);

		if (!this.func_176552_j()) {
			iblockstate = iblockstate.func_177226_a(field_176554_a, (meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP);
		}

		return iblockstate;
	}

	@Nonnull
	@Override
	public abstract T getWoodType(int meta);

	@Override
	public int func_176201_c(IBlockState state) {
		T woodType = state.func_177229_b(getVariant());
		int meta = woodType.getMetadata() - blockNumber * VARIANTS_PER_BLOCK;

		if (!this.func_176552_j() && state.func_177229_b(field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
			meta |= 8;
		}

		return meta;
	}

	@Override
	public int func_180651_a(IBlockState state) {
		return state.func_177229_b(getVariant()).getMetadata() - blockNumber * VARIANTS_PER_BLOCK;
	}

	@Override
	public Item func_180660_a(IBlockState state, Random rand, int fortune) {
		T woodType = state.func_177229_b(getVariant());
		ItemStack slab = TreeManager.woodAccess.getStack(woodType, getBlockKind(), isFireproof());
		return slab.func_77973_b();
	}

	@SuppressWarnings("deprecation") // this is the way the vanilla slabs work
	@Override
	public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
		T woodType = state.func_177229_b(getVariant());
		ItemStack slab = TreeManager.woodAccess.getStack(woodType, getBlockKind(), isFireproof());
		return new ItemStack(slab.func_77973_b(), 1, func_176201_c(state));
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		manager.registerVariant(item, WoodHelper.getResourceLocations(this));
		manager.registerItemModel(item, new WoodHelper.WoodMeshDefinition(this));
	}

	@Override
	public String func_150002_b(int meta) {
		T woodType = getWoodType(meta);
		return WoodHelper.getDisplayName(this, woodType);
	}

	@Override
	public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> list) {
		if (!func_176552_j()) {
			for (T woodType : getVariant().func_177700_c()) {
				list.add(TreeManager.woodAccess.getStack(woodType, getBlockKind(), fireproof));
			}
		}
	}

	@Override
	public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
		int meta = func_176201_c(blockState);
		T woodType = getWoodType(meta);
		return woodType.getHardness();
	}

	@Override
	public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
		return fireproof ? 0 : 20;
	}

	@Override
	public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
		return fireproof ? 0 : 5;
	}

	@Nonnull
	@Override
	public WoodBlockKind getBlockKind() {
		return WoodBlockKind.SLAB;
	}

	@Override
	public IProperty func_176551_l() {
		return getVariant();
	}

	@Override
	public Comparable<?> func_185674_a(ItemStack stack) {
		return getWoodType(stack.func_77960_j());
	}

	@Nonnull
	@Override
	public Collection<T> getWoodTypes() {
		return getVariant().func_177700_c();
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void registerStateMapper() {
		String blockPath = func_176552_j() ? "double_slab" : getBlockKind().toString();
		Proxies.render.registerStateMapper(this, new WoodTypeStateMapper(this, blockPath, getVariant()));
	}
}
