/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.arboriculture.blocks;

import javax.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;

import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodHelper;
import forestry.core.proxy.Proxies;

public class BlockArbDoor extends BlockDoor implements IWoodTyped, IItemModelRegister, IStateMapperRegister {
	private final EnumForestryWoodType woodType;

	public BlockArbDoor(EnumForestryWoodType woodType) {
		super(Material.field_151575_d);
		this.woodType = woodType;

		setHarvestLevel("axe", 0);
		func_149647_a(Tabs.tabArboriculture);
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void registerModel(Item item, IModelManager manager) {
		manager.registerVariant(item, WoodHelper.getResourceLocations(this));
		manager.registerItemModel(item, new WoodHelper.WoodMeshDefinition(this));
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void registerStateMapper() {
		Proxies.render.registerStateMapper(this, new WoodTypeStateMapper(this, null).addPropertyToRemove(field_176522_N));
	}

	@Nonnull
	@Override
	public WoodBlockKind getBlockKind() {
		return WoodBlockKind.DOOR;
	}

	@Override
	public boolean isFireproof() {
		return false;
	}

	@Nonnull
	@Override
	public EnumForestryWoodType getWoodType(int meta) {
		return woodType;
	}

	@Nonnull
	@Override
	public Collection<EnumForestryWoodType> getWoodTypes() {
		return Collections.singleton(woodType);
	}

	@Override
	public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
		int meta = func_176201_c(blockState);
		EnumForestryWoodType woodType = getWoodType(meta);
		return woodType.getHardness();
	}

	/**
	 * Get the Item that this Block should drop when harvested.
	 */
	@Override
	public Item func_180660_a(IBlockState state, Random rand, int fortune) {
		return state.func_177229_b(field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? null : getItem();
	}

	@Override
	@SideOnly(Side.CLIENT)
	public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
		return new ItemStack(getItem());
	}

	private Item getItem() {
		return TreeManager.woodAccess.getStack(woodType, getBlockKind(), false).func_77973_b();
	}
}
