/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks.log;

import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodHelper;
import forestry.arboriculture.blocks.MaterialArbWood;
import forestry.arboriculture.blocks.WoodTypeStateMapper;
import forestry.arboriculture.blocks.property.PropertyWoodType;
import forestry.core.proxy.Proxies;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockForestryLog<T extends Enum<T>>
extends BlockLog
implements IWoodTyped,
IStateMapperRegister,
IItemModelRegister {
    protected static final int VARIANTS_PER_BLOCK = 4;
    protected static final int VARIANTS_META_MASK = 3;
    private final boolean fireproof;
    private final int blockNumber;

    protected BlockForestryLog(boolean fireproof, int blockNumber) {
        this.fireproof = fireproof;
        this.blockNumber = blockNumber;
        PropertyWoodType<T> variant = this.getVariant();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(variant, variant.getFirstType()).func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
        this.setHarvestLevel("axe", 0);
        this.func_149647_a(Tabs.tabArboriculture);
    }

    @Override
    @Nonnull
    public final WoodBlockKind getBlockKind() {
        return WoodBlockKind.LOG;
    }

    @Override
    public final boolean isFireproof() {
        return this.fireproof;
    }

    public final int getBlockNumber() {
        return this.blockNumber;
    }

    public final Material func_149688_o(IBlockState state) {
        return MaterialArbWood.ARB_WOOD;
    }

    private static BlockLog.EnumAxis getAxis(int meta) {
        switch (meta & 0xC) {
            case 0: {
                return BlockLog.EnumAxis.Y;
            }
            case 4: {
                return BlockLog.EnumAxis.X;
            }
            case 8: {
                return BlockLog.EnumAxis.Z;
            }
        }
        return BlockLog.EnumAxis.NONE;
    }

    public final IBlockState func_176203_a(int meta) {
        T woodType = this.getWoodType(meta);
        BlockLog.EnumAxis axis = BlockForestryLog.getAxis(meta);
        return this.func_176223_P().func_177226_a(this.getVariant(), woodType).func_177226_a((IProperty)field_176299_a, (Comparable)axis);
    }

    public final int func_176201_c(IBlockState state) {
        int i = this.func_180651_a(state);
        switch ((BlockLog.EnumAxis)state.func_177229_b((IProperty)field_176299_a)) {
            case X: {
                i |= 4;
                break;
            }
            case Z: {
                i |= 8;
                break;
            }
            case NONE: {
                i |= 0xC;
            }
        }
        return i;
    }

    @Nonnull
    public abstract PropertyWoodType<T> getVariant();

    @Nonnull
    public abstract T getWoodType(int var1);

    @Nonnull
    public final Collection<T> getWoodTypes() {
        return this.getVariant().func_177700_c();
    }

    protected final BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getVariant(), field_176299_a});
    }

    protected final ItemStack func_180643_i(IBlockState state) {
        int meta = this.func_180651_a(state);
        Item item = Item.func_150898_a((Block)this);
        return new ItemStack(item, 1, meta);
    }

    public final int func_180651_a(IBlockState state) {
        return ((IWoodType)((Object)((Enum)((Object)state.func_177229_b(this.getVariant()))))).getMetadata() - this.blockNumber * 4;
    }

    public final IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        BlockLog.EnumAxis axis = BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k());
        T woodType = this.getWoodType(meta);
        return this.func_176223_P().func_177226_a(this.getVariant(), woodType).func_177226_a((IProperty)field_176299_a, (Comparable)axis);
    }

    public final void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (Enum woodType : this.getVariant().func_177700_c()) {
            list.add(TreeManager.woodAccess.getStack((IWoodType)((Object)woodType), this.getBlockKind(), this.fireproof));
        }
    }

    public final float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        int meta = this.func_176201_c(blockState);
        T woodType = this.getWoodType(meta);
        return ((IWoodType)woodType).getHardness();
    }

    public final int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.fireproof) {
            return 0;
        }
        if (face == EnumFacing.DOWN) {
            return 20;
        }
        if (face != EnumFacing.UP) {
            return 10;
        }
        return 5;
    }

    public final int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.fireproof) {
            return 0;
        }
        return 5;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void registerModel(Item item, IModelManager manager) {
        manager.registerVariant(item, WoodHelper.getResourceLocations(this));
        manager.registerItemModel(item, new WoodHelper.WoodMeshDefinition(this));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void registerStateMapper() {
        Proxies.render.registerStateMapper((Block)this, (IStateMapper)new WoodTypeStateMapper(this, this.getVariant()));
    }
}

