/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.core.ForestryAPI;
import forestry.api.core.climate.IClimateRegion;
import forestry.api.core.climate.IClimateSource;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ClimateEventHandler {
    Map<Integer, Integer> serverTicks = new HashMap<Integer, Integer>();

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        int dim = event.world.field_73011_w.getDimension();
        if (event.phase == TickEvent.Phase.END) {
            int ticks;
            if (!this.serverTicks.containsKey(dim)) {
                this.serverTicks.put(dim, 1);
            }
            if ((ticks = this.serverTicks.get(dim).intValue()) % 20 == 0) {
                for (IClimateRegion region : ForestryAPI.climateManager.getRegions().get(dim)) {
                    region.updateClimate();
                }
            }
            if (ForestryAPI.climateManager.getSources().get(dim) != null) {
                for (IClimateSource source : ForestryAPI.climateManager.getSources().get(dim).values()) {
                    source.changeClimate(ticks, ForestryAPI.climateManager.getRegionForPos(event.world, source.getPos()));
                }
            }
            this.serverTicks.put(dim, ticks + 1);
        }
    }
}

