/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodHelper;
import forestry.arboriculture.blocks.MaterialArbWood;
import forestry.arboriculture.blocks.WoodTypeStateMapper;
import forestry.core.proxy.Proxies;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockForestryFenceGate<T extends Enum<T>>
extends BlockFenceGate
implements IWoodTyped,
IItemModelRegister,
IStateMapperRegister {
    private final boolean fireproof;
    private final T woodType;

    public BlockForestryFenceGate(boolean fireproof, T woodType) {
        super(BlockPlanks.EnumType.OAK);
        this.fireproof = fireproof;
        this.woodType = woodType;
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(Tabs.tabArboriculture);
    }

    public Material func_149688_o(IBlockState state) {
        return MaterialArbWood.ARB_WOOD;
    }

    @Override
    public boolean isFireproof() {
        return this.fireproof;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.fireproof) {
            return 0;
        }
        return 20;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.fireproof) {
            return 0;
        }
        return 5;
    }

    @Override
    @Nonnull
    public WoodBlockKind getBlockKind() {
        return WoodBlockKind.FENCE_GATE;
    }

    @Nonnull
    public T getWoodType(int meta) {
        return this.woodType;
    }

    @Nonnull
    public Collection<T> getWoodTypes() {
        return Collections.singleton(this.woodType);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        Proxies.render.registerStateMapper((Block)this, (IStateMapper)new WoodTypeStateMapper(this, null).addPropertyToRemove((IProperty)field_176465_b));
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(TreeManager.woodAccess.getStack((IWoodType)this.woodType, this.getBlockKind(), this.fireproof));
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        int meta = this.func_176201_c(blockState);
        T woodType = this.getWoodType(meta);
        return ((IWoodType)woodType).getHardness();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerVariant(item, WoodHelper.getResourceLocations(this));
        manager.registerItemModel(item, new WoodHelper.WoodMeshDefinition(this));
    }
}

