/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.proxy;

import forestry.api.core.ForestryAPI;
import forestry.core.models.BlockModelIndex;
import forestry.core.proxy.Proxies;
import forestry.greenhouse.PluginGreenhouse;
import forestry.greenhouse.blocks.BlockGreenhouseType;
import forestry.greenhouse.models.ModelGreenhouse;
import forestry.greenhouse.proxy.ProxyGreenhouse;
import forestry.greenhouse.tiles.TileGreenhouseSprinkler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.animation.AnimationTESR;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class ProxyGreenhouseClient
extends ProxyGreenhouse {
    @Override
    public void initializeModels() {
        for (BlockGreenhouseType greenhouseType : BlockGreenhouseType.VALUES) {
            if (greenhouseType == BlockGreenhouseType.DOOR) continue;
            if (greenhouseType == BlockGreenhouseType.SPRINKLER) {
                ClientRegistry.bindTileEntitySpecialRenderer(TileGreenhouseSprinkler.class, (TileEntitySpecialRenderer)new AnimationTESR());
                continue;
            }
            if (greenhouseType == BlockGreenhouseType.BUTTERFLY_HATCH && !ForestryAPI.enabledPlugins.contains("forestry.lepidopterology")) continue;
            Proxies.render.registerBlockModel(new BlockModelIndex(new ModelResourceLocation("forestry:greenhouse." + (Object)((Object)greenhouseType)), new ModelResourceLocation("forestry:greenhouse", "inventory"), new ModelGreenhouse(), Block.func_149634_a((Item)PluginGreenhouse.blocks.getGreenhouseBlock(greenhouseType).func_77973_b())));
        }
    }
}

