/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IArmorNaturalist;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.ICheckPollinatable;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ILeafTranslator;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.IPollinatable;
import forestry.api.genetics.ISaplingTranslator;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.arboriculture.genetics.pollination.CheckPollinatableTree;
import forestry.core.config.Config;
import forestry.core.genetics.ItemGE;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GeneticsUtil {
    public static boolean hasNaturalistEye(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack armorItemStack = player.field_71071_by.field_70460_b[3];
        if (armorItemStack == null) {
            return false;
        }
        Item armorItem = armorItemStack.func_77973_b();
        if (!(armorItem instanceof IArmorNaturalist)) {
            return false;
        }
        IArmorNaturalist armorNaturalist = (IArmorNaturalist)armorItem;
        return armorNaturalist.canSeePollination(player, armorItemStack, true);
    }

    public static boolean canNurse(IButterfly butterfly, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IButterflyNursery) {
            return ((IButterflyNursery)tile).canNurse(butterfly);
        }
        return GeneticsUtil.getPollen(world, pos) != null;
    }

    public static ICheckPollinatable getCheckPollinatable(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IPollinatable) {
            return (IPollinatable)tile;
        }
        ITree pollen = GeneticsUtil.getPollen(world, pos);
        if (pollen != null) {
            return new CheckPollinatableTree(pollen);
        }
        return null;
    }

    public static IPollinatable getOrCreatePollinatable(GameProfile owner, World world, BlockPos pos) {
        ITree pollen;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IPollinatable) {
            return (IPollinatable)tile;
        }
        if (Config.pollinateVanillaTrees && (pollen = GeneticsUtil.getPollen(world, pos)) != null) {
            pollen.setLeaves(world, owner, pos);
            return (IPollinatable)world.func_175625_s(pos);
        }
        return null;
    }

    @Nullable
    public static ITree getPollen(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ICheckPollinatable) {
            return ((ICheckPollinatable)tile).getPollen();
        }
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState == null) {
            return null;
        }
        Block block = blockState.func_177230_c();
        ILeafTranslator leafTranslator = AlleleManager.leafTranslators.get(block);
        if (leafTranslator == null) {
            return null;
        }
        return leafTranslator.getTreeFromLeaf(blockState);
    }

    public static IIndividual getGeneticEquivalent(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemGE) {
            return ((ItemGE)item).getIndividual(itemStack);
        }
        ISaplingTranslator saplingTranslator = AlleleManager.saplingTranslation.get(item);
        if (saplingTranslator == null) {
            return null;
        }
        return saplingTranslator.getTreeFromSapling(itemStack);
    }

    public static ItemStack convertToGeneticEquivalent(ItemStack foreign) {
        if (foreign == null) {
            return null;
        }
        if (AlleleManager.alleleRegistry.getSpeciesRoot(foreign) != null) {
            return foreign;
        }
        IIndividual individual = GeneticsUtil.getGeneticEquivalent(foreign);
        if (individual instanceof ITree) {
            ItemStack equivalent = TreeManager.treeRoot.getMemberStack(individual, EnumGermlingType.SAPLING);
            equivalent.field_77994_a = foreign.field_77994_a;
            return equivalent;
        }
        return null;
    }

    public static int getResearchComplexity(IAlleleSpecies species, IChromosomeType speciesChromosome) {
        return 1 + GeneticsUtil.getGeneticAdvancement(species, new HashSet<IAlleleSpecies>(), speciesChromosome);
    }

    private static int getGeneticAdvancement(IAlleleSpecies species, Set<IAlleleSpecies> exclude, IChromosomeType speciesChromosome) {
        int highest = 0;
        exclude.add(species);
        for (IMutation iMutation : species.getRoot().getPaths(species, speciesChromosome)) {
            highest = GeneticsUtil.getHighestAdvancement(iMutation.getAllele0(), highest, exclude, speciesChromosome);
            highest = GeneticsUtil.getHighestAdvancement(iMutation.getAllele1(), highest, exclude, speciesChromosome);
        }
        return 1 + highest;
    }

    private static int getHighestAdvancement(IAlleleSpecies mutationSpecies, int highest, Set<IAlleleSpecies> exclude, IChromosomeType speciesChromosome) {
        if (exclude.contains(mutationSpecies) || AlleleManager.alleleRegistry.isBlacklisted(mutationSpecies.getUID())) {
            return highest;
        }
        int otherAdvance = GeneticsUtil.getGeneticAdvancement(mutationSpecies, exclude, speciesChromosome);
        return otherAdvance > highest ? otherAdvance : highest;
    }
}

