/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.core.climate.IClimatePosition;
import forestry.api.core.climate.IClimateRegion;
import forestry.api.multiblock.IGreenhouseController;
import forestry.core.climate.ClimatePosition;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class ClimateRoom
implements IClimateRegion {
    protected World world;
    protected IGreenhouseController controller;
    protected Map<BlockPos, IClimatePosition> positions;

    public ClimateRoom(ClimateRoom room, Map<BlockPos, IClimatePosition> innerPositions) {
        this.world = room.getWorld();
        this.controller = room.controller;
        HashMap<BlockPos, IClimatePosition> newPositions = new HashMap<BlockPos, IClimatePosition>();
        for (Map.Entry<BlockPos, IClimatePosition> positionEntry : innerPositions.entrySet()) {
            IClimatePosition position = this.positions.get(positionEntry.getKey());
            if (position == null) {
                newPositions.put(positionEntry.getKey(), positionEntry.getValue());
                continue;
            }
            newPositions.put(positionEntry.getKey(), position);
        }
        this.positions = newPositions;
    }

    public ClimateRoom(IGreenhouseController controller, Map<BlockPos, IClimatePosition> innerPositions) {
        this.world = controller.getWorldObj();
        this.controller = controller;
        this.positions = innerPositions;
    }

    public ClimateRoom(IGreenhouseController controller, NBTTagCompound nbtTag) {
        this.world = controller.getWorldObj();
        this.controller = controller;
        this.positions = new HashMap<BlockPos, IClimatePosition>();
        this.readFromNBT(nbtTag);
    }

    @Override
    public void updateClimate() {
        for (Map.Entry<BlockPos, IClimatePosition> position : this.positions.entrySet()) {
            BlockPos pos = position.getKey();
            if (!this.world.func_175667_e(pos)) continue;
            this.updateSides(pos);
            if (this.controller.isAssembled()) continue;
            Biome biome = this.world.func_180494_b(pos);
            float biomeTemperature = biome.func_185353_n();
            float biomeHumidity = biome.func_76727_i();
            IClimatePosition climatedInfo = this.positions.get(pos);
            if (climatedInfo.getTemperature() != biomeTemperature) {
                if (climatedInfo.getTemperature() > biomeTemperature) {
                    climatedInfo.addTemperature(-0.01f);
                } else {
                    climatedInfo.addTemperature(0.01f);
                }
            }
            if (climatedInfo.getHumidity() == biomeHumidity) continue;
            if (climatedInfo.getHumidity() > biomeHumidity) {
                climatedInfo.addHumidity(-0.01f);
                continue;
            }
            climatedInfo.addHumidity(0.01f);
        }
    }

    private void updateSides(BlockPos pos) {
        IClimatePosition climatedInfo = this.positions.get(pos);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos facePos = pos.func_177972_a(facing);
            IClimatePosition climatedInfoFace = this.positions.get(facePos);
            if (climatedInfoFace == null) continue;
            if (climatedInfo.getTemperature() > climatedInfoFace.getTemperature() + 0.01f) {
                climatedInfo.addTemperature(-0.01f);
                climatedInfoFace.addTemperature(0.01f);
            }
            if (!(climatedInfo.getHumidity() > climatedInfoFace.getHumidity() + 0.01f)) continue;
            climatedInfo.addHumidity(-0.01f);
            climatedInfoFace.addHumidity(0.01f);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList positionList = new NBTTagList();
        for (Map.Entry<BlockPos, IClimatePosition> entry : this.positions.entrySet()) {
            BlockPos pos = entry.getKey();
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("XPos", pos.func_177958_n());
            tag.func_74768_a("YPos", pos.func_177956_o());
            tag.func_74768_a("ZPos", pos.func_177952_p());
            positionList.func_74742_a((NBTBase)entry.getValue().writeToNBT(tag));
        }
        nbt.func_74782_a("Positions", (NBTBase)positionList);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList positionList = nbt.func_150295_c("Positions", 10);
        for (int i = 0; i < positionList.func_74745_c(); ++i) {
            NBTTagCompound positionTag = positionList.func_150305_b(i);
            int xPos = positionTag.func_74762_e("XPos");
            int yPos = positionTag.func_74762_e("YPos");
            int zPos = positionTag.func_74762_e("ZPos");
            BlockPos pos = new BlockPos(xPos, yPos, zPos);
            ClimatePosition position = new ClimatePosition(this, pos);
            position.readFromNBT(positionTag);
            this.positions.put(pos, position);
        }
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public Map<BlockPos, IClimatePosition> getPositions() {
        return this.positions;
    }
}

