/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.climate;

import forestry.api.core.climate.IClimateManager;
import forestry.api.core.climate.IClimatePosition;
import forestry.api.core.climate.IClimateRegion;
import forestry.api.core.climate.IClimateSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class ClimateManager
implements IClimateManager {
    protected Map<Integer, List<IClimateRegion>> regions = new HashMap<Integer, List<IClimateRegion>>();
    protected Map<Integer, Map<BlockPos, IClimateSource>> sources;

    @Override
    public void addRegion(IClimateRegion region) {
        if (region == null) {
            return;
        }
        List<IClimateRegion> regions = this.getOrCreateRegions(region.getWorld());
        Set<BlockPos> positions = region.getPositions().keySet();
        for (IClimateRegion otherRegion : regions) {
            for (BlockPos pos : otherRegion.getPositions().keySet()) {
                if (!positions.contains(pos)) continue;
                return;
            }
        }
        if (!regions.contains(region)) {
            regions.add(region);
        }
    }

    @Override
    public void removeRegion(IClimateRegion region) {
        if (region == null) {
            return;
        }
        List<IClimateRegion> regions = this.getOrCreateRegions(region.getWorld());
        if (regions.contains(region)) {
            regions.remove(region);
        }
    }

    @Override
    public void removeSource(IClimateSource source) {
        if (this.sources.get(source.getWorld().field_73011_w.getDimension()) == null) {
            this.sources.put(source.getWorld().field_73011_w.getDimension(), new HashMap());
        }
        if (this.sources.get(source.getWorld().field_73011_w.getDimension()).keySet().contains(source.getPos())) {
            this.sources.get(source.getWorld().field_73011_w.getDimension()).remove(source.getPos(), source);
        }
    }

    @Override
    public void addSource(IClimateSource source) {
        if (this.sources.get(source.getWorld().field_73011_w.getDimension()) == null) {
            this.sources.put(source.getWorld().field_73011_w.getDimension(), new HashMap());
        }
        if (!this.sources.get(source.getWorld().field_73011_w.getDimension()).keySet().contains(source.getPos())) {
            this.sources.get(source.getWorld().field_73011_w.getDimension()).put(source.getPos(), source);
        }
    }

    @Override
    public float getTemperature(World world, BlockPos pos) {
        IClimatePosition position;
        Biome biome = world.func_180494_b(pos);
        IClimateRegion region = this.getRegionForPos(world, pos);
        if (region != null && (position = region.getPositions().get(pos)) != null) {
            return position.getTemperature();
        }
        return biome.func_185353_n();
    }

    @Override
    public float getHumidity(World world, BlockPos pos) {
        IClimatePosition position;
        Biome biome = world.func_180494_b(pos);
        IClimateRegion region = this.getRegionForPos(world, pos);
        if (region != null && (position = region.getPositions().get(pos)) != null) {
            return position.getHumidity();
        }
        return biome.func_76727_i();
    }

    @Override
    public Map<Integer, List<IClimateRegion>> getRegions() {
        return this.regions;
    }

    @Override
    public IClimateRegion getRegionForPos(World world, BlockPos pos) {
        for (IClimateRegion region : this.getOrCreateRegions(world)) {
            if (!region.getPositions().keySet().contains(pos)) continue;
            return region;
        }
        return null;
    }

    public List<IClimateRegion> getOrCreateRegions(World world) {
        List<IClimateRegion> regions = this.regions.get(world.field_73011_w.getDimension());
        if (regions == null) {
            regions = new ArrayList<IClimateRegion>();
            this.regions.put(world.field_73011_w.getDimension(), regions);
        }
        return regions;
    }

    @Override
    public Map<Integer, Map<BlockPos, IClimateSource>> getSources() {
        return this.sources;
    }
}

