/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.squeezer;

import forestry.api.recipes.ISqueezerRecipe;
import forestry.core.recipes.jei.ForestryRecipeWrapper;
import forestry.factory.recipes.ISqueezerContainerRecipe;
import javax.annotation.Nonnull;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;

public class SqueezerRecipeHandler<R extends ForestryRecipeWrapper>
implements IRecipeHandler<R> {
    @Nonnull
    private final Class<R> recipeClass;

    public SqueezerRecipeHandler(@Nonnull Class<R> recipeClass) {
        this.recipeClass = recipeClass;
    }

    @Nonnull
    public Class<R> getRecipeClass() {
        return this.recipeClass;
    }

    @Nonnull
    public String getRecipeCategoryUid() {
        return "forestry.squeezer";
    }

    @Nonnull
    public String getRecipeCategoryUid(@Nonnull R recipe) {
        return "forestry.squeezer";
    }

    @Nonnull
    public IRecipeWrapper getRecipeWrapper(@Nonnull R recipe) {
        return recipe;
    }

    public boolean isRecipeValid(@Nonnull R wrapper) {
        if (wrapper.getFluidOutputs() == null || wrapper.getFluidOutputs().isEmpty()) {
            return false;
        }
        if (wrapper.getInputs() == null || wrapper.getInputs().isEmpty()) {
            return false;
        }
        if (wrapper.getOutputs() == null || wrapper.getOutputs().isEmpty()) {
            return false;
        }
        if (((ForestryRecipeWrapper)((Object)wrapper)).getRecipe() instanceof ISqueezerContainerRecipe) {
            ISqueezerContainerRecipe recipe = (ISqueezerContainerRecipe)((ForestryRecipeWrapper)((Object)wrapper)).getRecipe();
            return recipe.getProcessingTime() > 0 && recipe.getRemnantsChance() > 0.0f;
        }
        ISqueezerRecipe recipe = (ISqueezerRecipe)((ForestryRecipeWrapper)((Object)wrapper)).getRecipe();
        return recipe.getProcessingTime() > 0 && recipe.getRemnantsChance() > 0.0f;
    }
}

