/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.api.apiculture.IHiveDrop;
import forestry.api.apiculture.hives.IHiveDescription;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public final class Hive {
    private final IHiveDescription hiveDescription;
    private final List<IHiveDrop> drops = new ArrayList<IHiveDrop>();

    public Hive(IHiveDescription hiveDescription) {
        if (hiveDescription == null) {
            throw new IllegalArgumentException("Tried to create hive with null hive description");
        }
        this.hiveDescription = hiveDescription;
    }

    public IBlockState getHiveBlockState() {
        return this.hiveDescription.getBlockState();
    }

    public void addDrops(List<IHiveDrop> drops) {
        this.drops.addAll(drops);
    }

    public List<IHiveDrop> getDrops() {
        return this.drops;
    }

    public float genChance() {
        return this.hiveDescription.getGenChance();
    }

    public void postGen(World world, BlockPos pos) {
        this.hiveDescription.postGen(world, pos);
    }

    public boolean isGoodBiome(Biome biome) {
        return this.hiveDescription.isGoodBiome(biome);
    }

    public boolean isGoodHumidity(EnumHumidity humidity) {
        return this.hiveDescription.isGoodHumidity(humidity);
    }

    public boolean isGoodTemperature(EnumTemperature temperature) {
        return this.hiveDescription.isGoodTemperature(temperature);
    }

    public boolean isValidLocation(World world, BlockPos pos) {
        return this.hiveDescription.getHiveGen().isValidLocation(world, pos);
    }

    public boolean canReplace(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        return this.hiveDescription.getHiveGen().canReplace(blockState, world, pos);
    }

    @Nullable
    public BlockPos getPosForHive(World world, int x, int z) {
        return this.hiveDescription.getHiveGen().getPosForHive(world, x, z);
    }

    public String toString() {
        return this.hiveDescription + " hive";
    }
}

