/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.flowers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IFlowerAcceptableRule;
import forestry.api.genetics.IFlowerGrowthHelper;
import forestry.api.genetics.IFlowerGrowthRule;
import forestry.api.genetics.IFlowerRegistry;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.flowers.Flower;
import forestry.apiculture.flowers.GrowthRuleDirtGrass;
import forestry.apiculture.flowers.GrowthRuleFertilize;
import forestry.apiculture.flowers.GrowthRuleFlowerPot;
import forestry.apiculture.flowers.GrowthRuleMycelium;
import forestry.apiculture.flowers.GrowthRuleNone;
import forestry.apiculture.flowers.GrowthRuleSnow;
import forestry.core.utils.VectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public final class FlowerRegistry
implements IFlowerRegistry,
IFlowerGrowthHelper {
    private final Set<String> defaultFlowerTypes = ImmutableSet.of((Object)"flowersVanilla", (Object)"flowersNether", (Object)"flowersCacti", (Object)"flowersMushrooms", (Object)"flowersEnd", (Object)"flowersJungle", (Object[])new String[]{"flowersSnow", "flowersWheat", "flowersGourd"});
    private final HashMultimap<String, IFlowerAcceptableRule> registeredRules = HashMultimap.create();
    private final HashMultimap<String, Block> registeredBlocks = HashMultimap.create();
    private final HashMultimap<String, Flower> registeredFlowers = HashMultimap.create();
    private final ArrayListMultimap<String, IFlowerGrowthRule> growthRules = ArrayListMultimap.create();
    private final Map<String, TreeMap<Double, Flower>> chances = new HashMap<String, TreeMap<Double, Flower>>();

    public FlowerRegistry() {
        this.registerVanillaGrowthRules();
    }

    @Override
    public void registerAcceptableFlower(Block block, String ... flowerTypes) {
        this.registerFlower(block, Short.MAX_VALUE, 0.0, flowerTypes);
    }

    @Override
    public void registerAcceptableFlower(Block block, int meta, String ... flowerTypes) {
        this.registerFlower(block, meta, 0.0, flowerTypes);
    }

    @Override
    public void registerAcceptableFlowerRule(IFlowerAcceptableRule acceptableFlower, String ... flowerTypes) {
        for (String flowerType : flowerTypes) {
            this.registeredRules.put((Object)flowerType, (Object)acceptableFlower);
        }
    }

    @Override
    public void registerPlantableFlower(Block block, int meta, double weight, String ... flowerTypes) {
        this.registerFlower(block, meta, weight, flowerTypes);
    }

    private void registerFlower(Block block, int meta, double weight, String ... flowerTypes) {
        if (block == null) {
            return;
        }
        if (weight <= 0.0) {
            weight = 0.0;
        }
        if (weight >= 1.0) {
            weight = 1.0;
        }
        Flower newFlower = new Flower(block, meta, weight);
        for (String flowerType : flowerTypes) {
            if (flowerType == null) {
                throw new NullPointerException("Tried to register flower with null type. " + block);
            }
            Set flowers = this.registeredFlowers.get((Object)flowerType);
            flowers.add(newFlower);
            Set blocks = this.registeredBlocks.get((Object)flowerType);
            blocks.add(block);
            if (!this.chances.containsKey(flowerType)) continue;
            this.chances.remove(flowerType);
        }
    }

    private static Vec3i getArea(IBeeGenome genome, IBeeModifier beeModifier) {
        Vec3i genomeTerritory = genome.getTerritory();
        float housingModifier = beeModifier.getTerritoryModifier(genome, 1.0f);
        return VectUtil.scale(genomeTerritory, housingModifier * 3.0f);
    }

    @Override
    @Nonnull
    public List<BlockPos> getAcceptedFlowerCoordinates(IBeeHousing beeHousing, IBee bee, String flowerType, int maxFlowers) {
        if (!this.registeredFlowers.containsKey((Object)flowerType)) {
            return Collections.emptyList();
        }
        Set acceptableRules = this.registeredRules.get((Object)flowerType);
        Set acceptedBlocks = this.registeredBlocks.get((Object)flowerType);
        Set acceptedFlowers = this.registeredFlowers.get((Object)flowerType);
        World world = beeHousing.getWorldObj();
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(beeHousing);
        Vec3i area = FlowerRegistry.getArea(bee.getGenome(), beeModifier);
        BlockPos minPos = beeHousing.getCoordinates().func_177982_a(-area.func_177958_n() / 2, -area.func_177956_o() / 2, -area.func_177952_p() / 2);
        BlockPos maxPos = minPos.func_177971_a(area);
        ArrayList<BlockPos> flowerCoords = new ArrayList<BlockPos>();
        for (BlockPos.MutableBlockPos posBlock : BlockPos.func_177975_b((BlockPos)minPos, (BlockPos)maxPos)) {
            for (IFlowerAcceptableRule acceptableRule : acceptableRules) {
                if (!acceptableRule.isAcceptableFlower(flowerType, world, (BlockPos)posBlock)) continue;
                flowerCoords.add(posBlock.func_185334_h());
                if (flowerCoords.size() < maxFlowers) continue;
                return flowerCoords;
            }
            if (!FlowerRegistry.isAcceptedFlower(acceptedBlocks, acceptedFlowers, world, (BlockPos)posBlock)) continue;
            flowerCoords.add(posBlock.func_185334_h());
            if (flowerCoords.size() < maxFlowers) continue;
            return flowerCoords;
        }
        return flowerCoords;
    }

    @Override
    public boolean isAcceptedFlower(String flowerType, World world, BlockPos pos) {
        if (!this.registeredFlowers.containsKey((Object)flowerType)) {
            return false;
        }
        Set acceptedCustom = this.registeredRules.get((Object)flowerType);
        for (IFlowerAcceptableRule acceptableFlower : acceptedCustom) {
            if (!acceptableFlower.isAcceptableFlower(flowerType, world, pos)) continue;
            return true;
        }
        Set acceptedBlocks = this.registeredBlocks.get((Object)flowerType);
        Set acceptedFlowers = this.registeredFlowers.get((Object)flowerType);
        return FlowerRegistry.isAcceptedFlower(acceptedBlocks, acceptedFlowers, world, pos);
    }

    private static boolean isAcceptedFlower(Set<Block> acceptedBlocks, Set<Flower> acceptedFlowers, World world, BlockPos pos) {
        int meta;
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block instanceof BlockFlowerPot) {
            TileEntity tile = world.func_175625_s(pos);
            TileEntityFlowerPot tileFlowerPot = (TileEntityFlowerPot)tile;
            Item item = tileFlowerPot.func_145965_a();
            block = Block.func_149634_a((Item)item);
            meta = tileFlowerPot.func_145966_b();
        } else {
            if (!acceptedBlocks.contains(block)) {
                return false;
            }
            meta = block.func_176201_c(blockState);
        }
        Flower flower = new Flower(block, meta, 0.0);
        return acceptedFlowers.contains(flower);
    }

    @Override
    public boolean growFlower(String flowerType, World world, IIndividual individual, BlockPos pos) {
        if (!this.growthRules.containsKey((Object)flowerType)) {
            return false;
        }
        for (IFlowerGrowthRule rule : this.growthRules.get((Object)flowerType)) {
            if (!rule.growFlower(this, flowerType, world, pos)) continue;
            return true;
        }
        return false;
    }

    public Set<Flower> getAcceptableFlowers(String flowerType) {
        return ImmutableSet.copyOf((Collection)this.registeredFlowers.get((Object)flowerType));
    }

    @Override
    public void registerGrowthRule(IFlowerGrowthRule rule, String ... flowerTypes) {
        if (rule == null) {
            return;
        }
        for (String flowerType : flowerTypes) {
            this.growthRules.get((Object)flowerType).add(rule);
        }
    }

    public Flower getRandomPlantableFlower(String flowerType, Random rand) {
        TreeMap<Double, Flower> chancesMap = this.getChancesMap(flowerType);
        double maxKey = chancesMap.lastKey() + 1.0;
        return chancesMap.get(chancesMap.lowerKey(rand.nextDouble() * maxKey));
    }

    public Collection<String> getFlowerTypes() {
        return new ArrayList<String>((Collection<String>)Sets.union(this.defaultFlowerTypes, (Set)this.registeredFlowers.keySet()));
    }

    private TreeMap<Double, Flower> getChancesMap(String flowerType) {
        if (!this.chances.containsKey(flowerType)) {
            TreeMap<Double, Flower> flowerChances = new TreeMap<Double, Flower>();
            double count = 0.0;
            for (Flower flower : this.registeredFlowers.get((Object)flowerType)) {
                if (!flower.isPlantable()) continue;
                flowerChances.put(count, flower);
                count += flower.getWeight();
            }
            this.chances.put(flowerType, flowerChances);
        }
        return this.chances.get(flowerType);
    }

    private void registerVanillaGrowthRules() {
        this.registerGrowthRule(new GrowthRuleDirtGrass(), "flowersVanilla", "flowersSnow");
        this.registerGrowthRule(new GrowthRuleSnow(), "flowersSnow");
        this.registerGrowthRule(new GrowthRuleFlowerPot(), "flowersVanilla", "flowersSnow", "flowersMushrooms", "flowersCacti", "flowersJungle");
        this.registerGrowthRule(new GrowthRuleMycelium(), "flowersMushrooms");
        this.registerGrowthRule(new GrowthRuleNone(), "flowersEnd");
        this.registerGrowthRule(new GrowthRuleFertilize(Blocks.field_150394_bc, Blocks.field_150393_bb), "flowersGourd");
        this.registerGrowthRule(new GrowthRuleFertilize(Blocks.field_150464_aj), "flowersWheat");
    }

    @Override
    public boolean plantRandomFlower(String flowerType, World world, BlockPos pos) {
        Flower flower = this.getRandomPlantableFlower(flowerType, world.field_73012_v);
        return world.func_180501_a(pos, flower.getBlock().func_176203_a(flower.getMeta()), 2);
    }
}

